/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;
import org.jboss.logging.Logger;

class PoolFiller
implements Runnable {
    private static Logger log = Logger.getLogger(PoolFiller.class);
    private static final PoolFiller FILLER = new PoolFiller();
    private final LinkedList<ManagedConnectionPool> pools = new LinkedList();
    private final Thread fillerThread;
    private static final String THREAD_FILLER_NAME = "JCA PoolFiller";
    private AtomicBoolean threadStarted = new AtomicBoolean(false);

    static void fillPool(ManagedConnectionPool mcp) {
        FILLER.internalFillPool(mcp);
    }

    PoolFiller() {
        this.fillerThread = new Thread((Runnable)this, THREAD_FILLER_NAME);
        this.fillerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        SecurityActions.setThreadContextClassLoader(myClassLoader);
        while (true) {
            LinkedList<ManagedConnectionPool> linkedList;
            ManagedConnectionPool mcp = null;
            while (true) {
                linkedList = this.pools;
                synchronized (linkedList) {
                    mcp = this.pools.removeFirst();
                }
                if (mcp == null) break;
                mcp.fillToMin();
            }
            try {
                linkedList = this.pools;
                synchronized (linkedList) {
                    while (this.pools.isEmpty()) {
                        this.pools.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFillPool(ManagedConnectionPool mcp) {
        if (this.threadStarted.compareAndSet(false, true)) {
            this.fillerThread.start();
        }
        LinkedList<ManagedConnectionPool> linkedList = this.pools;
        synchronized (linkedList) {
            this.pools.addLast(mcp);
            this.pools.notifyAll();
        }
    }
}

