/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.xa;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.connectionmanager.xa.api.XidWrapper;

public class XidWrapperImpl
implements XidWrapper {
    private static final long serialVersionUID = 8226195409384804425L;
    private int formatId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private transient String cachedToString;
    private transient int cachedHashCode;
    private boolean pad;

    public XidWrapperImpl(Xid xid) {
        this(false, xid);
    }

    public XidWrapperImpl(boolean pad, Xid xid) {
        this.pad = pad;
        this.branchQualifier = pad ? new byte[64] : new byte[xid.getBranchQualifier().length];
        System.arraycopy(xid.getBranchQualifier(), 0, this.branchQualifier, 0, xid.getBranchQualifier().length);
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.formatId = xid.getFormatId();
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] temp = (byte[])this.branchQualifier.clone();
        return temp;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] temp = (byte[])this.globalTransactionId.clone();
        return temp;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)object;
        return this.formatId == other.getFormatId() && Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId()) && Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.formatId;
            for (int i = 0; i < this.globalTransactionId.length; ++i) {
                this.cachedHashCode += this.globalTransactionId[i];
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("XidWrapper[FormatId=").append(this.getFormatId());
            buffer.append(" GlobalId=").append(new String(this.getGlobalTransactionId()).trim());
            buffer.append(" BranchQual=");
            buffer.append(new String(this.getBranchQualifier()).trim());
            buffer.append(']');
            this.cachedToString = buffer.toString();
        }
        return this.cachedToString;
    }
}

