/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.io.Closeable;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.deployment.descriptor.JBossServiceXmlDescriptorParser;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.model.ParseResult;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class ServiceDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(500L);
    private final XMLMapper xmlMapper = XMLMapper.Factory.create();
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public ServiceDeploymentParsingProcessor() {
        this.xmlMapper.registerRootElement(new QName("urn:jboss:service:7.0", "server"), (XMLElementReader)new JBossServiceXmlDescriptorParser());
    }

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        block11: {
            VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            String deploymentRootName = deploymentRoot.getName();
            VirtualFile serviceXmlFile = null;
            if (deploymentRootName.endsWith(".jar") || deploymentRootName.endsWith(".sar")) {
                serviceXmlFile = deploymentRoot.getChild("META-INF/jboss-service.xml");
            } else if (deploymentRootName.endsWith("-service.xml")) {
                serviceXmlFile = deploymentRoot;
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(xmlStream);
                ParseResult result = new ParseResult();
                this.xmlMapper.parseDocument((Object)result, reader);
                JBossServiceXmlDescriptor xmlDescriptor = (JBossServiceXmlDescriptor)result.getResult();
                if (xmlDescriptor != null) {
                    context.putAttachment(JBossServiceXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block11;
                }
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]");
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]", (Throwable)e);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }
}

