/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.domain.client.api.DomainClient;
import org.jboss.as.domain.client.api.DomainUpdateApplier;
import org.jboss.as.domain.client.api.DomainUpdateResult;
import org.jboss.as.domain.client.api.HostUpdateResult;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerStatus;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanResult;
import org.jboss.as.domain.client.api.deployment.DomainDeploymentManager;
import org.jboss.as.domain.client.impl.DomainDeploymentManagerImpl;
import org.jboss.as.domain.client.impl.DomainUpdateApplierContextImpl;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.client.impl.deployment.DeploymentPlanResultReader;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;

public class DomainClientImpl
implements DomainClient {
    private static final MarshallingConfiguration CONFIG = new MarshallingConfiguration();
    private volatile DomainDeploymentManager deploymentManager;
    private static final long CONNECTION_TIMEOUT;
    private final InetAddress address;
    private final int port;
    private final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private final ExecutorService executorService = Executors.newCachedThreadPool(this.threadFactory);

    public DomainClientImpl(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public DomainModel getDomainModel() {
        try {
            return (DomainModel)new GetDomainOperation().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get domain model.", (Throwable)e);
        }
    }

    @Override
    public List<DomainUpdateResult<?>> applyUpdates(List<AbstractDomainModelUpdate<?>> updates) {
        try {
            return (List)new ApplyUpdatesOperation(updates).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to apply domain updates", (Throwable)e);
        }
    }

    @Override
    public <R, P> void applyUpdate(AbstractDomainModelUpdate<R> update, DomainUpdateApplier<R, P> updateApplier, P param) {
        try {
            DomainUpdateApplierResponse response = (DomainUpdateApplierResponse)new ApplyUpdateToModelOperation(update).executeForResult(this.getConnectionStrategy());
            if (response.isCancelled()) {
                updateApplier.handleCancelled();
            } else if (response.getDomainFailure() != null) {
                updateApplier.handleDomainFailed(response.getDomainFailure());
            } else {
                if (response.getHostFailures().size() > 0) {
                    updateApplier.handleHostFailed(response.getHostFailures());
                }
                if (response.getServers().size() > 0) {
                    AbstractServerModelUpdate serverUpdate = update.getServerModelUpdate();
                    DomainUpdateApplier.Context context = DomainUpdateApplierContextImpl.createDomainUpdateApplierContext(this, response.getServers(), serverUpdate);
                    updateApplier.handleReady(context, param);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if deployment name is unique", e);
        }
    }

    @Override
    public byte[] addDeploymentContent(String name, String runtimeName, InputStream stream) {
        try {
            return (byte[])new AddDeploymentContentOperation(name, runtimeName, stream).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to add deployment content.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainDeploymentManager getDeploymentManager() {
        if (this.deploymentManager == null) {
            DomainClientImpl domainClientImpl = this;
            synchronized (domainClientImpl) {
                if (this.deploymentManager == null) {
                    this.deploymentManager = new DomainDeploymentManagerImpl(this);
                }
            }
        }
        return this.deploymentManager;
    }

    @Override
    public List<HostUpdateResult<?>> applyHostUpdates(String hostName, List<AbstractHostModelUpdate<?>> updates) {
        try {
            return (List)new ApplyHostUpdatesOperation(hostName, updates).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to apply host updates", (Throwable)e);
        }
    }

    @Override
    public HostModel getHostModel(String serverManagerName) {
        try {
            return (HostModel)new GetHostModelOperation(serverManagerName).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get host model", (Throwable)e);
        }
    }

    @Override
    public List<String> getServerManagerNames() {
        try {
            return (List)new GetServerManagerNamesOperation().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get server manager names", (Throwable)e);
        }
    }

    @Override
    public ServerModel getServerModel(String serverManagerName, String serverName) {
        try {
            return (ServerModel)new GetServerModelOperation(serverManagerName, serverName).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get server model", (Throwable)e);
        }
    }

    @Override
    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        try {
            return (Map)new GetServerStatusesOperation().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get server statuses", (Throwable)e);
        }
    }

    @Override
    public ServerStatus startServer(String serverManagerName, String serverName) {
        try {
            return (ServerStatus)((Object)new StartServerOperation(serverManagerName, serverName).executeForResult(this.getConnectionStrategy()));
        }
        catch (Exception e) {
            throw new ManagementException("Failed to start server " + serverName, (Throwable)e);
        }
    }

    @Override
    public ServerStatus stopServer(String serverManagerName, String serverName, long gracefulShutdownTimeout, TimeUnit timeUnit) {
        long ms = gracefulShutdownTimeout < 0L ? -1L : timeUnit.toMillis(gracefulShutdownTimeout);
        try {
            return (ServerStatus)((Object)new StopServerOperation(serverManagerName, serverName, ms).executeForResult(this.getConnectionStrategy()));
        }
        catch (Exception e) {
            throw new ManagementException("Failed to stop server " + serverName, (Throwable)e);
        }
    }

    @Override
    public ServerStatus restartServer(String serverManagerName, String serverName, long gracefulShutdownTimeout, TimeUnit timeUnit) {
        long ms = gracefulShutdownTimeout < 0L ? -1L : timeUnit.toMillis(gracefulShutdownTimeout);
        try {
            return (ServerStatus)((Object)new RestartServerOperation(serverManagerName, serverName, ms).executeForResult(this.getConnectionStrategy()));
        }
        catch (Exception e) {
            throw new ManagementException("Failed to restart server " + serverName, (Throwable)e);
        }
    }

    boolean isDeploymentNameUnique(String deploymentName) {
        try {
            return (Boolean)new CheckUnitDeploymentNameOperation(deploymentName).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if deployment name is unique", e);
        }
    }

    Future<DeploymentPlanResult> execute(DeploymentPlan deploymentPlan) {
        try {
            return new ExecuteDeploymentPlanOperation(deploymentPlan).execute(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get deployment result future", e);
        }
    }

    <R, P> Future<Void> applyUpdateToServer(AbstractServerModelUpdate<R> update, ServerIdentity server, UpdateResultHandler<R, P> resultHandler, P param) {
        try {
            return new ApplyUpdateToServerOperation(update, server, resultHandler, param).execute(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get update result future", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)CONFIG);
    }

    private ManagementRequestConnectionStrategy getConnectionStrategy() {
        return new ManagementRequestConnectionStrategy.EstablishConnectingStrategy(this.address, this.port, CONNECTION_TIMEOUT, this.executorService, this.threadFactory);
    }

    static {
        CONFIG.setClassResolver((ClassResolver)new SimpleClassResolver(DomainClientImpl.class.getClassLoader()));
        CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    }

    private class CheckUnitDeploymentNameOperation
    extends DomainClientRequest<Boolean> {
        private final String deploymentName;

        private CheckUnitDeploymentNameOperation(String name) {
            this.deploymentName = name;
        }

        public final byte getRequestCode() {
            return 56;
        }

        protected final byte getResponseCode() {
            return 64;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(50);
                output.writeUTF(this.deploymentName);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Boolean receiveResponse(InputStream inputStream) throws IOException {
            Boolean bl;
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)57);
                bl = input.readBoolean();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
            return bl;
        }
    }

    private class AddDeploymentContentOperation
    extends DomainClientRequest<byte[]> {
        private final String name;
        private final String runtimeName;
        private final InputStream inputStream;

        private AddDeploymentContentOperation(String name, String runtimeName, InputStream inputStream) {
            this.name = name;
            this.runtimeName = runtimeName;
            this.inputStream = inputStream;
        }

        public final byte getRequestCode() {
            return 49;
        }

        protected final byte getResponseCode() {
            return 55;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(50);
                output.writeUTF(this.name);
                output.writeByte(51);
                output.writeUTF(this.runtimeName);
                output.writeByte(52);
                try {
                    int read;
                    byte[] buffer = new byte[8192];
                    while ((read = this.inputStream.read(buffer)) != -1) {
                        output.write(buffer, 0, read);
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)this.inputStream);
                }
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final byte[] receiveResponse(InputStream inputStream) throws IOException {
            byte[] byArray;
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)53);
                int length = input.readInt();
                byte[] hash = new byte[length];
                ProtocolUtils.expectHeader((DataInput)input, (int)54);
                input.readFully(hash);
                byArray = hash;
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
            return byArray;
        }
    }

    private class ExecuteDeploymentPlanOperation
    extends DomainClientRequest<DeploymentPlanResult> {
        private final DeploymentPlan deploymentPlan;

        private ExecuteDeploymentPlanOperation(DeploymentPlan deploymentPlan) {
            this.deploymentPlan = deploymentPlan;
        }

        public final byte getRequestCode() {
            return 65;
        }

        protected final byte getResponseCode() {
            return 87;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(66);
            marshaller.writeObject((Object)this.deploymentPlan);
            marshaller.finish();
        }

        protected final DeploymentPlanResult receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            DeploymentPlanResultReader reader = new DeploymentPlanResultReader(this.deploymentPlan, unmarshaller);
            DeploymentPlanResult result = reader.readResult();
            unmarshaller.finish();
            return result;
        }
    }

    private class ApplyUpdateToServerOperation<R, P>
    extends DomainClientRequest<Void> {
        private final AbstractServerModelUpdate<R> update;
        private final ServerIdentity server;
        private final UpdateResultHandler<R, P> resultHandler;
        private final P param;

        private ApplyUpdateToServerOperation(AbstractServerModelUpdate<R> update, ServerIdentity server, UpdateResultHandler<R, P> resultHandler, P param) {
            this.update = update;
            this.server = server;
            this.resultHandler = resultHandler;
            this.param = param;
        }

        public final byte getRequestCode() {
            return 36;
        }

        protected final byte getResponseCode() {
            return 48;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(37);
            marshaller.writeUTF(this.server.getHostName());
            marshaller.writeByte(38);
            marshaller.writeUTF(this.server.getServerGroupName());
            marshaller.writeByte(39);
            marshaller.writeUTF(this.server.getServerName());
            marshaller.writeByte(40);
            marshaller.writeObject(this.update);
            marshaller.finish();
        }

        protected final Void receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)41);
            UpdateResultHandlerResponse result = (UpdateResultHandlerResponse)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, UpdateResultHandlerResponse.class);
            unmarshaller.finish();
            if (this.resultHandler != null) {
                if (result.isCancelled()) {
                    this.resultHandler.handleCancellation(this.param);
                } else if (result.isRolledBack()) {
                    this.resultHandler.handleRollbackSuccess(this.param);
                } else if (result.isTimedOut()) {
                    this.resultHandler.handleTimeout(this.param);
                } else if (result.getFailureResult() != null) {
                    this.resultHandler.handleFailure(result.getFailureResult(), this.param);
                } else {
                    this.resultHandler.handleSuccess(result.getSuccessResult(), this.param);
                }
            }
            unmarshaller.finish();
            return null;
        }
    }

    private class ApplyUpdateToModelOperation
    extends DomainClientRequest<DomainUpdateApplierResponse> {
        final AbstractDomainModelUpdate<?> update;

        private ApplyUpdateToModelOperation(AbstractDomainModelUpdate<?> update) {
            this.update = update;
        }

        public final byte getRequestCode() {
            return 34;
        }

        protected final byte getResponseCode() {
            return 35;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(20);
            marshaller.writeObject(this.update);
            marshaller.finish();
        }

        protected final DomainUpdateApplierResponse receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)32);
            DomainUpdateApplierResponse rsp = (DomainUpdateApplierResponse)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DomainUpdateApplierResponse.class);
            unmarshaller.finish();
            return rsp;
        }
    }

    private class ApplyHostUpdatesOperation
    extends DomainClientRequest<List<HostUpdateResult<?>>> {
        final String serverManagerName;
        final List<AbstractHostModelUpdate<?>> updates;

        private ApplyHostUpdatesOperation(String serverManagerName, List<AbstractHostModelUpdate<?>> updates) {
            this.serverManagerName = serverManagerName;
            this.updates = updates;
        }

        public final byte getRequestCode() {
            return 88;
        }

        protected final byte getResponseCode() {
            return 97;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(37);
            marshaller.writeUTF(this.serverManagerName);
            marshaller.writeByte(24);
            marshaller.writeInt(this.updates.size());
            for (AbstractHostModelUpdate<?> update : this.updates) {
                marshaller.writeByte(89);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected final List<HostUpdateResult<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)25);
            int updateCount = unmarshaller.readInt();
            ArrayList results = new ArrayList(updateCount);
            for (int i = 0; i < updateCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)96);
                HostUpdateResult updateResult = (HostUpdateResult)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, HostUpdateResult.class);
                results.add(updateResult);
            }
            unmarshaller.finish();
            return results;
        }
    }

    private class ApplyUpdatesOperation
    extends DomainClientRequest<List<DomainUpdateResult<?>>> {
        final List<AbstractDomainModelUpdate<?>> updates;

        private ApplyUpdatesOperation(List<AbstractDomainModelUpdate<?>> updates) {
            this.updates = updates;
        }

        public final byte getRequestCode() {
            return 23;
        }

        protected final byte getResponseCode() {
            return 33;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(24);
            marshaller.writeInt(this.updates.size());
            for (AbstractDomainModelUpdate<?> update : this.updates) {
                marshaller.writeByte(20);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected final List<DomainUpdateResult<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)25);
            int updateCount = unmarshaller.readInt();
            ArrayList results = new ArrayList(updateCount);
            for (int i = 0; i < updateCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)32);
                DomainUpdateResult updateResult = (DomainUpdateResult)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DomainUpdateResult.class);
                results.add(updateResult);
            }
            unmarshaller.finish();
            return results;
        }
    }

    private abstract class ServerStatusChangeOperation
    extends DomainClientRequest<ServerStatus> {
        private final String serverManagerName;
        private final String serverName;
        private final Long gracefulTimeout;

        private ServerStatusChangeOperation(String serverManagerName, String serverName, Long gracefulTimeout) {
            this.serverManagerName = serverManagerName;
            this.serverName = serverName;
            this.gracefulTimeout = gracefulTimeout;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(37);
            marshaller.writeUTF(this.serverManagerName);
            marshaller.writeByte(39);
            marshaller.writeUTF(this.serverName);
            if (this.gracefulTimeout != null) {
                marshaller.writeByte(120);
                marshaller.writeLong(this.gracefulTimeout.longValue());
            }
            marshaller.finish();
        }

        protected final ServerStatus receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)115);
            ServerStatus serverStatus = (ServerStatus)((Object)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerStatus.class));
            unmarshaller.finish();
            return serverStatus;
        }
    }

    private class RestartServerOperation
    extends ServerStatusChangeOperation {
        private RestartServerOperation(String serverManagerName, String serverName, long gracefulTimeout) {
            super(serverManagerName, serverName, gracefulTimeout);
        }

        public final byte getRequestCode() {
            return 122;
        }

        protected final byte getResponseCode() {
            return 123;
        }
    }

    private class StopServerOperation
    extends ServerStatusChangeOperation {
        private StopServerOperation(String serverManagerName, String serverName, long gracefulTimeout) {
            super(serverManagerName, serverName, gracefulTimeout);
        }

        public final byte getRequestCode() {
            return 119;
        }

        protected final byte getResponseCode() {
            return 121;
        }
    }

    private class StartServerOperation
    extends ServerStatusChangeOperation {
        private StartServerOperation(String serverManagerName, String serverName) {
            super(serverManagerName, serverName, null);
        }

        public final byte getRequestCode() {
            return 117;
        }

        protected final byte getResponseCode() {
            return 118;
        }
    }

    private class GetServerStatusesOperation
    extends DomainClientRequest<Map<ServerIdentity, ServerStatus>> {
        private GetServerStatusesOperation() {
        }

        public final byte getRequestCode() {
            return 113;
        }

        protected final byte getResponseCode() {
            return 116;
        }

        protected final Map<ServerIdentity, ServerStatus> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)114);
            int count = unmarshaller.readInt();
            HashMap<ServerIdentity, ServerStatus> results = new HashMap<ServerIdentity, ServerStatus>(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)73);
                String hostName = unmarshaller.readUTF();
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)80);
                String groupName = unmarshaller.readUTF();
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)81);
                String serverName = unmarshaller.readUTF();
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)115);
                ServerStatus serverStatus = (ServerStatus)((Object)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerStatus.class));
                results.put(new ServerIdentity(hostName, groupName, serverName), serverStatus);
            }
            unmarshaller.finish();
            return results;
        }
    }

    private class GetServerModelOperation
    extends DomainClientRequest<ServerModel> {
        private final String serverManagerName;
        private final String serverName;

        private GetServerModelOperation(String serverManagerName, String serverName) {
            this.serverManagerName = serverManagerName;
            this.serverName = serverName;
        }

        public final byte getRequestCode() {
            return 104;
        }

        protected final byte getResponseCode() {
            return 112;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(37);
            marshaller.writeUTF(this.serverManagerName);
            marshaller.writeByte(39);
            marshaller.writeUTF(this.serverName);
            marshaller.finish();
        }

        protected final ServerModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)105);
            ServerModel serverModel = (ServerModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerModel.class);
            unmarshaller.finish();
            return serverModel;
        }
    }

    private class GetHostModelOperation
    extends DomainClientRequest<HostModel> {
        private final String serverManagerName;

        private GetHostModelOperation(String serverManagerName) {
            this.serverManagerName = serverManagerName;
        }

        public final byte getRequestCode() {
            return 98;
        }

        protected final byte getResponseCode() {
            return 100;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = DomainClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(37);
            marshaller.writeUTF(this.serverManagerName);
            marshaller.finish();
        }

        protected final HostModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)99);
            HostModel hostModel = (HostModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, HostModel.class);
            unmarshaller.finish();
            return hostModel;
        }
    }

    private class GetServerManagerNamesOperation
    extends DomainClientRequest<List<String>> {
        private GetServerManagerNamesOperation() {
        }

        public final byte getRequestCode() {
            return 101;
        }

        protected final byte getResponseCode() {
            return 103;
        }

        protected final List<String> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)102);
            int count = unmarshaller.readInt();
            ArrayList<String> results = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)73);
                results.add(unmarshaller.readUTF());
            }
            unmarshaller.finish();
            return results;
        }
    }

    private class GetDomainOperation
    extends DomainClientRequest<DomainModel> {
        private GetDomainOperation() {
        }

        public final byte getRequestCode() {
            return 21;
        }

        protected final byte getResponseCode() {
            return 22;
        }

        protected final DomainModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = DomainClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)19);
            DomainModel domainModel = (DomainModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, DomainModel.class);
            unmarshaller.finish();
            return domainModel;
        }
    }

    private abstract class DomainClientRequest<T>
    extends ManagementRequest<T> {
        private DomainClientRequest() {
        }

        protected byte getHandlerId() {
            return 10;
        }
    }
}

