/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.model.UpdateFailedException;

public class DomainUpdateApplierResponse
implements Serializable {
    private static final long serialVersionUID = -3525117172870002485L;
    private final UpdateFailedException domainFailure;
    private final Map<String, UpdateFailedException> hostFailures = new HashMap<String, UpdateFailedException>();
    private final List<ServerIdentity> servers = new ArrayList<ServerIdentity>();
    private final boolean cancelled;
    private final boolean rolledBack;

    public DomainUpdateApplierResponse(boolean cancelled) {
        this.cancelled = cancelled;
        this.rolledBack = !cancelled;
        this.domainFailure = null;
    }

    public DomainUpdateApplierResponse(UpdateFailedException domainFailure) {
        this.domainFailure = domainFailure;
        this.cancelled = false;
        this.rolledBack = false;
    }

    public DomainUpdateApplierResponse(Map<String, UpdateFailedException> hostFailures) {
        this.domainFailure = null;
        if (hostFailures != null) {
            this.hostFailures.putAll(hostFailures);
        }
        this.cancelled = false;
        this.rolledBack = false;
    }

    public DomainUpdateApplierResponse(List<ServerIdentity> servers) {
        this.domainFailure = null;
        if (servers != null) {
            this.servers.addAll(servers);
        }
        this.cancelled = false;
        this.rolledBack = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public UpdateFailedException getDomainFailure() {
        return this.domainFailure;
    }

    public Map<String, UpdateFailedException> getHostFailures() {
        return Collections.unmodifiableMap(this.hostFailures);
    }

    public List<ServerIdentity> getServers() {
        return Collections.unmodifiableList(this.servers);
    }
}

