/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.domain.client.api.deployment.DeploymentAction;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.impl.deployment.DeploymentPlanImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentSetPlanImpl;

class AbstractDeploymentPlanBuilder {
    final boolean globalRollback;
    private final List<DeploymentSetPlanImpl> setPlans = new ArrayList<DeploymentSetPlanImpl>();

    AbstractDeploymentPlanBuilder() {
        this.setPlans.add(new DeploymentSetPlanImpl());
        this.globalRollback = false;
    }

    AbstractDeploymentPlanBuilder(AbstractDeploymentPlanBuilder existing, boolean globalRollback) {
        this.setPlans.addAll(existing.setPlans);
        this.globalRollback = globalRollback;
    }

    AbstractDeploymentPlanBuilder(AbstractDeploymentPlanBuilder existing) {
        this.setPlans.addAll(existing.setPlans);
        this.globalRollback = existing.globalRollback;
    }

    AbstractDeploymentPlanBuilder(AbstractDeploymentPlanBuilder existing, DeploymentSetPlanImpl setPlan, boolean replace) {
        this(existing);
        if (replace) {
            this.setPlans.set(this.setPlans.size() - 1, setPlan);
        } else {
            this.setPlans.add(setPlan);
        }
    }

    public DeploymentAction getLastAction() {
        return this.getCurrentDeploymentSetPlan().getLastAction();
    }

    DeploymentSetPlanImpl getCurrentDeploymentSetPlan() {
        return this.setPlans.get(this.setPlans.size() - 1);
    }

    public DeploymentPlan build() {
        return new DeploymentPlanImpl(this.setPlans, this.globalRollback);
    }
}

