/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.ServerUpdateResult;
import org.jboss.as.domain.client.api.deployment.DeploymentAction;
import org.jboss.as.domain.client.api.deployment.DeploymentActionResult;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentActionResult;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.client.impl.deployment.ServerGroupDeploymentActionResultImpl;
import org.jboss.as.model.UpdateFailedException;

class DeploymentActionResultImpl
implements DeploymentActionResult {
    private final DeploymentAction deploymentAction;
    private final DomainUpdateApplierResponse applierResponse;
    private final Map<String, ServerGroupDeploymentActionResult> serverResults = new HashMap<String, ServerGroupDeploymentActionResult>();
    private DomainUpdateApplierResponse rollbackResponse;

    DeploymentActionResultImpl(DeploymentAction deploymentAction, DomainUpdateApplierResponse applierResponse) {
        assert (deploymentAction != null) : "deploymentAction is null";
        assert (applierResponse != null) : "applierResponse is null";
        this.deploymentAction = deploymentAction;
        this.applierResponse = applierResponse;
    }

    @Override
    public DeploymentAction getDeploymentAction() {
        return this.deploymentAction;
    }

    @Override
    public UUID getDeploymentActionId() {
        return this.deploymentAction.getId();
    }

    @Override
    public UpdateFailedException getDomainControllerFailure() {
        return this.applierResponse.getDomainFailure();
    }

    @Override
    public Map<String, ServerGroupDeploymentActionResult> getResultsByServerGroup() {
        return Collections.unmodifiableMap(this.serverResults);
    }

    @Override
    public Map<String, UpdateFailedException> getServerManagerFailures() {
        return this.applierResponse.getHostFailures();
    }

    @Override
    public boolean isCancelledByDomain() {
        return this.applierResponse.isCancelled();
    }

    @Override
    public boolean isRolledBackOnDomain() {
        return this.rollbackResponse != null ? true : this.applierResponse.isRolledBack();
    }

    @Override
    public UpdateFailedException getDomainControllerRollbackFailure() {
        return this.rollbackResponse == null ? null : this.rollbackResponse.getDomainFailure();
    }

    @Override
    public Map<String, UpdateFailedException> getServerManagerRollbackFailures() {
        return this.rollbackResponse == null ? Collections.emptyMap() : this.rollbackResponse.getHostFailures();
    }

    void markRolledBack(DomainUpdateApplierResponse rollbackResponse) {
        this.rollbackResponse = rollbackResponse;
    }

    void storeServerUpdateResult(ServerIdentity server, ServerUpdateResult<Void> result) {
        ServerGroupDeploymentActionResultImpl sgdar = (ServerGroupDeploymentActionResultImpl)this.serverResults.get(server.getServerGroupName());
        if (sgdar == null) {
            sgdar = new ServerGroupDeploymentActionResultImpl(server.getServerGroupName());
            this.serverResults.put(server.getServerGroupName(), sgdar);
        }
        sgdar.storeServerResult(server.getServerName(), result);
    }
}

