/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.as.domain.client.api.deployment.AddDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.DeployDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.domain.client.api.deployment.RemoveDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.ReplaceDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlan;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.UndeployDeploymentPlanBuilder;
import org.jboss.as.domain.client.impl.deployment.AbstractDeploymentPlanBuilder;
import org.jboss.as.domain.client.impl.deployment.AddDeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.DeployDeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentContentDistributor;
import org.jboss.as.domain.client.impl.deployment.DeploymentSetPlanImpl;
import org.jboss.as.domain.client.impl.deployment.RemoveDeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.ReplaceDeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.ServerGroupDeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.UndeployDeploymentPlanBuilderImpl;

class DeploymentPlanBuilderImpl
extends AbstractDeploymentPlanBuilder
implements DeploymentPlanBuilder {
    private final DeploymentContentDistributor deploymentDistributor;

    DeploymentPlanBuilderImpl(DeploymentContentDistributor deploymentDistributor) {
        if (deploymentDistributor == null) {
            throw new IllegalArgumentException("deploymentDistributor is null");
        }
        this.deploymentDistributor = deploymentDistributor;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, boolean globalRollback) {
        super(existing, globalRollback);
        this.deploymentDistributor = existing.deploymentDistributor;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan, boolean replace) {
        super(existing, setPlan, replace);
        this.deploymentDistributor = existing.deploymentDistributor;
    }

    @Override
    public AddDeploymentPlanBuilder add(File file) throws IOException, DuplicateDeploymentNameException {
        String name = file.getName();
        return this.add(name, name, file.toURI().toURL());
    }

    @Override
    public AddDeploymentPlanBuilder add(URL url) throws IOException, DuplicateDeploymentNameException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.add(name, name, url);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, File file) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, file.getName(), file.toURI().toURL());
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, URL url) throws IOException, DuplicateDeploymentNameException {
        String commonName = DeploymentPlanBuilderImpl.getName(url);
        return this.add(name, commonName, url);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, name, stream);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, String commonName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        byte[] hash = this.deploymentDistributor.distributeDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, commonName, hash);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new AddDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name) throws IOException {
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, null, null);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new AddDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public DeployDeploymentPlanBuilder deploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getDeployAction(key);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new DeployDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public UndeployDeploymentPlanBuilder undeploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getUndeployAction(key);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new UndeployDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public DeploymentPlanBuilder redeploy(String deploymentName) {
        DeploymentActionImpl mod = DeploymentActionImpl.getRedeployAction(deploymentName);
        return this.getNewBuilder(mod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder replace(String replacement, String toReplace) {
        DeploymentActionImpl mod = DeploymentActionImpl.getReplaceAction(replacement, toReplace);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new ReplaceDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(File file) throws IOException {
        String name = file.getName();
        return this.replace(name, name, file.toURI().toURL());
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(URL url) throws IOException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.replace(name, name, url);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, File file) throws IOException {
        return this.replace(name, name, file.toURI().toURL());
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, URL url) throws IOException {
        return this.replace(name, name, url);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, InputStream stream) throws IOException {
        return this.replace(name, name, stream);
    }

    @Override
    public RemoveDeploymentPlanBuilder replace(String name, String commonName, InputStream stream) throws IOException {
        byte[] hash = this.deploymentDistributor.distributeReplacementDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getFullReplaceAction(name, commonName, hash);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    @Override
    public RemoveDeploymentPlanBuilder remove(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveAction(key);
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl(this, newSet, !add);
    }

    ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        DeploymentSetPlanImpl newSet = currentSet.storeServerGroup(new ServerGroupDeploymentPlan(serverGroupName));
        return new ServerGroupDeploymentPlanBuilderImpl(this, newSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddDeploymentPlanBuilder add(String name, String commonName, URL url) throws IOException, DuplicateDeploymentNameException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            AddDeploymentPlanBuilder addDeploymentPlanBuilder = this.add(name, commonName, stream);
            return addDeploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoveDeploymentPlanBuilder replace(String name, String commonName, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            RemoveDeploymentPlanBuilder removeDeploymentPlanBuilder = this.replace(name, commonName, stream);
            return removeDeploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ignored) {}
        }
    }

    DeploymentPlanBuilderImpl getNewBuilder(DeploymentActionImpl mod) {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new DeploymentPlanBuilderImpl(this, newSet, !add);
    }

    private static String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(url + " is not a valid URI", e);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            throw new IllegalArgumentException("Cannot derive a deployment name from " + url + " -- use an overloaded method variant that takes a 'name' parameter");
        }
        return path.substring(idx + 1);
    }
}

