/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.domain.client.api.DomainUpdateListener;
import org.jboss.as.domain.client.api.RollbackCancelledException;
import org.jboss.as.domain.client.api.ServerIdentity;
import org.jboss.as.domain.client.api.deployment.DeploymentAction;
import org.jboss.as.domain.client.api.deployment.DeploymentActionResult;
import org.jboss.as.domain.client.api.deployment.DeploymentPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentPlanResult;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlanResult;
import org.jboss.as.domain.client.api.deployment.InvalidDeploymentPlanException;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentActionResult;
import org.jboss.as.domain.client.impl.DomainUpdateApplierResponse;
import org.jboss.as.domain.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentActionResultImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentPlanResultImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentSetPlanResultImpl;
import org.jboss.as.domain.client.impl.deployment.ServerUpdateResultImpl;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.marshalling.Unmarshaller;

public class DeploymentPlanResultReader {
    private final DeploymentPlan deploymentPlan;
    private final Unmarshaller unmarshaller;

    public DeploymentPlanResultReader(DeploymentPlan deploymentPlan, Unmarshaller unmarshaller) {
        assert (deploymentPlan != null) : "deploymentPlan is null";
        assert (unmarshaller != null) : "unmarshaller is null";
        this.unmarshaller = unmarshaller;
        this.deploymentPlan = deploymentPlan;
    }

    public DeploymentPlanResult readResult() throws IOException {
        this.expectHeader(67);
        UUID planId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        if (!this.deploymentPlan.getId().equals(planId)) {
            throw new IllegalStateException("Incorrect id " + planId + " for result; expected " + this.deploymentPlan.getId());
        }
        byte header = this.unmarshaller.readByte();
        if (header == 68) {
            InvalidDeploymentPlanException e = (InvalidDeploymentPlanException)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, InvalidDeploymentPlanException.class);
            return new DeploymentPlanResultImpl(this.deploymentPlan, e);
        }
        DeploymentPlanResultReader.expectHeader(header, 69);
        HashMap<UUID, DeploymentSetPlanResult> setResults = new HashMap<UUID, DeploymentSetPlanResult>();
        while ((header = this.readDeploymentSetResult(setResults)) == 69) {
        }
        if (header == 83) {
            while ((header = this.readDeploymentSetRollback(setResults)) == 83) {
            }
        }
        DeploymentPlanResultReader.expectHeader(header, 86);
        for (DeploymentSetPlan setPlan : this.deploymentPlan.getDeploymentSetPlans()) {
            for (DeploymentAction action : setPlan.getDeploymentActions()) {
                for (DomainUpdateListener<?> listener : ((DeploymentActionImpl)action).getListeners()) {
                    listener.handleComplete();
                }
            }
        }
        return new DeploymentPlanResultImpl(this.deploymentPlan, setResults);
    }

    private byte readDeploymentSetResult(Map<UUID, DeploymentSetPlanResult> setResults) throws IOException {
        UUID setId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentSetPlan setPlan = this.findDeploymentSet(setId);
        byte nextHeader = this.unmarshaller.readByte();
        DeploymentPlanResultReader.expectHeader(nextHeader, 70);
        HashMap<UUID, DeploymentActionResult> actionResults = new HashMap<UUID, DeploymentActionResult>();
        while ((nextHeader = this.readDeploymentActionResult(setPlan, actionResults)) == 70) {
        }
        if (nextHeader == 72) {
            while ((nextHeader = this.readServerDeploymentResult(actionResults)) == 72) {
            }
        }
        DeploymentSetPlanResultImpl setResult = new DeploymentSetPlanResultImpl(setPlan, actionResults);
        setResults.put(setId, setResult);
        return nextHeader;
    }

    private byte readDeploymentActionResult(DeploymentSetPlan setPlan, Map<UUID, DeploymentActionResult> actionResults) throws IOException {
        UUID actionId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentActionImpl action = this.findDeploymentAction(actionId, setPlan);
        Set<DomainUpdateListener<?>> listeners = action.getListeners();
        this.expectHeader(71);
        DomainUpdateApplierResponse duar = (DomainUpdateApplierResponse)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, DomainUpdateApplierResponse.class);
        DeploymentActionResultImpl actionResult = new DeploymentActionResultImpl(action, duar);
        actionResults.put(actionId, actionResult);
        for (DomainUpdateListener<?> listener : listeners) {
            if (duar.isCancelled()) {
                listener.handleCancelledByDomain();
                continue;
            }
            if (duar.isRolledBack()) {
                listener.handleDomainRollback();
                continue;
            }
            if (duar.getDomainFailure() != null) {
                listener.handleDomainFailed(duar.getDomainFailure());
                continue;
            }
            if (duar.getHostFailures().size() > 0) {
                listener.handleHostFailed(duar.getHostFailures());
                continue;
            }
            listener.handleServersIdentified(duar.getServers());
        }
        return this.unmarshaller.readByte();
    }

    private byte readServerDeploymentResult(Map<UUID, DeploymentActionResult> actionResults) throws IOException {
        UUID actionId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentActionResultImpl actionResult = (DeploymentActionResultImpl)actionResults.get(actionId);
        ServerIdentity serverId = this.readServerIdentity();
        this.expectHeader(82);
        UpdateResultHandlerResponse urhr = (UpdateResultHandlerResponse)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UpdateResultHandlerResponse.class);
        ServerUpdateResultImpl<Void> sur = new ServerUpdateResultImpl<Void>(actionId, serverId, urhr);
        actionResult.storeServerUpdateResult(serverId, sur);
        DeploymentActionImpl action = (DeploymentActionImpl)actionResult.getDeploymentAction();
        for (DomainUpdateListener<?> listener : action.getListeners()) {
            if (urhr.isCancelled()) {
                listener.handleCancellation(serverId);
                continue;
            }
            if (urhr.isRolledBack()) {
                listener.handleRollbackSuccess(serverId);
                continue;
            }
            if (urhr.isTimedOut()) {
                listener.handleTimeout(serverId);
                continue;
            }
            if (urhr.getFailureResult() != null) {
                listener.handleFailure(urhr.getFailureResult(), serverId);
                continue;
            }
            listener.handleSuccess(null, serverId);
        }
        return this.unmarshaller.readByte();
    }

    private byte readDeploymentSetRollback(Map<UUID, DeploymentSetPlanResult> setResults) throws IOException {
        UUID setId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentSetPlanResult setResult = setResults.get(setId);
        if (setResult == null) {
            throw new IOException("Unknown deployment set plan " + setId);
        }
        byte nextHeader = this.unmarshaller.readByte();
        DeploymentPlanResultReader.expectHeader(nextHeader, 70);
        while ((nextHeader = this.readDeploymentActionRollback(setResult)) != 70) {
        }
        if (nextHeader == 85) {
            while ((nextHeader = this.readServerDeploymentRollback(setResult)) == 85) {
            }
        }
        return nextHeader;
    }

    private byte readDeploymentActionRollback(DeploymentSetPlanResult setResult) throws IOException {
        UUID actionId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentActionImpl action = this.findDeploymentAction(actionId, setResult.getDeploymentSetPlan());
        Set<DomainUpdateListener<?>> listeners = action.getListeners();
        this.expectHeader(71);
        DomainUpdateApplierResponse duar = (DomainUpdateApplierResponse)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, DomainUpdateApplierResponse.class);
        DeploymentActionResultImpl actionResult = (DeploymentActionResultImpl)setResult.getDeploymentActionResults().get(actionId);
        if (actionResult != null) {
            actionResult.markRolledBack(duar);
            for (DomainUpdateListener<?> listener : listeners) {
                if (duar.isCancelled()) {
                    listener.handleDomainRollbackFailed(new RollbackCancelledException("Rollback of deployment action " + actionId + "was cancelled"));
                    continue;
                }
                if (duar.isRolledBack()) {
                    listener.handleDomainRollbackFailed(new RollbackCancelledException("Rollback of deployment action " + actionId + "was itself rolled back"));
                    continue;
                }
                if (duar.getDomainFailure() != null) {
                    listener.handleDomainRollbackFailed(duar.getDomainFailure());
                    continue;
                }
                if (duar.getHostFailures().size() > 0) {
                    listener.handleHostRollbackFailed(duar.getHostFailures());
                    continue;
                }
                listener.handleDomainRollback();
            }
        }
        byte nextHeader = this.unmarshaller.readByte();
        return nextHeader;
    }

    private byte readServerDeploymentRollback(DeploymentSetPlanResult setResult) throws IOException {
        UUID actionId = (UUID)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UUID.class);
        DeploymentActionResultImpl actionResult = (DeploymentActionResultImpl)setResult.getDeploymentActionResults().get(actionId);
        ServerIdentity serverId = this.readServerIdentity();
        this.expectHeader(82);
        UpdateResultHandlerResponse urhr = (UpdateResultHandlerResponse)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, UpdateResultHandlerResponse.class);
        if (actionResult != null) {
            DeploymentActionImpl action = (DeploymentActionImpl)actionResult.getDeploymentAction();
            for (DomainUpdateListener<?> listener : action.getListeners()) {
                if (urhr.isCancelled()) {
                    listener.handleRollbackCancellation(serverId);
                    continue;
                }
                if (urhr.getFailureResult() != null) {
                    listener.handleRollbackFailure(urhr.getFailureResult(), serverId);
                    continue;
                }
                if (urhr.isRolledBack()) {
                    listener.handleRollbackFailure((Throwable)((Object)new RollbackCancelledException("Rollback of deployment action " + actionId + "was itself rolled back")), serverId);
                    continue;
                }
                if (urhr.isTimedOut()) {
                    listener.handleRollbackTimeout(serverId);
                    continue;
                }
                listener.handleRollbackSuccess(serverId);
            }
            ServerGroupDeploymentActionResult sgdar = actionResult.getResultsByServerGroup().get(serverId.getServerGroupName());
            ServerUpdateResultImpl sur = (ServerUpdateResultImpl)sgdar.getResultByServer().get(serverId.getServerName());
            sur.markRolledBack(urhr);
        }
        return this.unmarshaller.readByte();
    }

    private ServerIdentity readServerIdentity() throws IOException {
        this.expectHeader(73);
        String hostName = (String)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, String.class);
        this.expectHeader(80);
        String groupName = (String)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, String.class);
        this.expectHeader(81);
        String serverName = (String)ProtocolUtils.unmarshal((Unmarshaller)this.unmarshaller, String.class);
        return new ServerIdentity(hostName, groupName, serverName);
    }

    private DeploymentSetPlan findDeploymentSet(UUID setId) {
        for (DeploymentSetPlan setPlan : this.deploymentPlan.getDeploymentSetPlans()) {
            if (!setId.equals(setPlan.getId())) continue;
            return setPlan;
        }
        throw new IllegalStateException("Deployment plan result included unknown deployment set id " + setId);
    }

    private DeploymentActionImpl findDeploymentAction(UUID actionId, DeploymentSetPlan setPlan) {
        for (DeploymentAction action : setPlan.getDeploymentActions()) {
            if (!actionId.equals(action.getId())) continue;
            return (DeploymentActionImpl)action;
        }
        throw new IllegalStateException("Deployment set plan result included unknown action id " + actionId);
    }

    void expectHeader(int expected) throws IOException {
        DeploymentPlanResultReader.expectHeader(this.unmarshaller.readByte(), expected);
    }

    private static void expectHeader(byte actual, int expected) throws IOException {
        if (actual != (byte)expected) {
            throw new IOException("Invalid byte token.  Expecting '" + expected + "' received '" + actual + "'");
        }
    }
}

