/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.domain.client.api.ServerUpdateResult;
import org.jboss.as.domain.client.api.deployment.DeploymentActionResult;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlan;
import org.jboss.as.domain.client.api.deployment.DeploymentSetPlanResult;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentActionResult;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlanResult;
import org.jboss.as.domain.client.impl.deployment.ServerDeploymentPlanResultImpl;
import org.jboss.as.domain.client.impl.deployment.ServerGroupDeploymentPlanResultImpl;

public class DeploymentSetPlanResultImpl
implements DeploymentSetPlanResult {
    private final DeploymentSetPlan plan;
    private final Map<UUID, DeploymentActionResult> results;
    private Map<String, ServerGroupDeploymentPlanResult> resultsByServerGroup;

    public DeploymentSetPlanResultImpl(DeploymentSetPlan plan, Map<UUID, DeploymentActionResult> results) {
        assert (plan != null) : "plan is null";
        assert (results != null) : "results is null";
        this.plan = plan;
        this.results = results;
    }

    @Override
    public Map<UUID, DeploymentActionResult> getDeploymentActionResults() {
        return Collections.unmodifiableMap(this.results);
    }

    @Override
    public UUID getDeploymentSetId() {
        return this.plan.getId();
    }

    @Override
    public DeploymentSetPlan getDeploymentSetPlan() {
        return this.plan;
    }

    @Override
    public synchronized Map<String, ServerGroupDeploymentPlanResult> getServerGroupResults() {
        if (this.resultsByServerGroup == null) {
            this.resultsByServerGroup = DeploymentSetPlanResultImpl.buildServerGroupResults(this.results);
        }
        return Collections.unmodifiableMap(this.resultsByServerGroup);
    }

    private static Map<String, ServerGroupDeploymentPlanResult> buildServerGroupResults(Map<UUID, DeploymentActionResult> deploymentActionResults) {
        HashMap<String, ServerGroupDeploymentPlanResult> serverGroupResults = new HashMap<String, ServerGroupDeploymentPlanResult>();
        for (Map.Entry<UUID, DeploymentActionResult> entry : deploymentActionResults.entrySet()) {
            UUID actionId = entry.getKey();
            DeploymentActionResult actionResult = entry.getValue();
            Map<String, ServerGroupDeploymentActionResult> actionResultsByServerGroup = actionResult.getResultsByServerGroup();
            for (ServerGroupDeploymentActionResult serverGroupActionResult : actionResultsByServerGroup.values()) {
                String serverGroupName = serverGroupActionResult.getServerGroupName();
                ServerGroupDeploymentPlanResultImpl sgdpr = (ServerGroupDeploymentPlanResultImpl)serverGroupResults.get(serverGroupName);
                if (sgdpr == null) {
                    sgdpr = new ServerGroupDeploymentPlanResultImpl(serverGroupName);
                    serverGroupResults.put(serverGroupName, sgdpr);
                }
                for (Map.Entry<String, ServerUpdateResult<Void>> serverEntry : serverGroupActionResult.getResultByServer().entrySet()) {
                    String serverName = serverEntry.getKey();
                    ServerUpdateResult<Void> sud = serverEntry.getValue();
                    ServerDeploymentPlanResultImpl sdpr = (ServerDeploymentPlanResultImpl)sgdpr.getServerResult(serverName);
                    if (sdpr == null) {
                        sdpr = new ServerDeploymentPlanResultImpl(serverName);
                        sgdpr.storeServerResult(serverName, sdpr);
                    }
                    sdpr.storeServerUpdateResult(actionId, sud);
                }
            }
        }
        return serverGroupResults;
    }
}

