/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jboss.as.domain.client.api.ServerUpdateResult;
import org.jboss.as.domain.client.api.deployment.ServerDeploymentPlanResult;

class ServerDeploymentPlanResultImpl
implements ServerDeploymentPlanResult {
    private final String serverName;
    private final Map<UUID, ServerUpdateResult<Void>> serverResults = new HashMap<UUID, ServerUpdateResult<Void>>();

    ServerDeploymentPlanResultImpl(String serverName) {
        assert (serverName != null) : "serverName is null";
        this.serverName = serverName;
    }

    @Override
    public Map<UUID, ServerUpdateResult<Void>> getDeploymentActionResults() {
        return Collections.unmodifiableMap(this.serverResults);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerUpdateResult<Void> getServerUpdateResult(UUID actionId) {
        Map<UUID, ServerUpdateResult<Void>> map = this.serverResults;
        synchronized (map) {
            return this.serverResults.get(actionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeServerUpdateResult(UUID actionId, ServerUpdateResult<Void> result) {
        Map<UUID, ServerUpdateResult<Void>> map = this.serverResults;
        synchronized (map) {
            this.serverResults.put(actionId, result);
        }
    }
}

