/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.client.impl.deployment;

import org.jboss.as.domain.client.api.deployment.DeploymentAction;
import org.jboss.as.domain.client.api.deployment.RemoveDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.domain.client.api.deployment.UndeployDeploymentPlanBuilder;
import org.jboss.as.domain.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentPlanBuilderImpl;
import org.jboss.as.domain.client.impl.deployment.DeploymentSetPlanImpl;
import org.jboss.as.domain.client.impl.deployment.RemoveDeploymentPlanBuilderImpl;

class UndeployDeploymentPlanBuilderImpl
extends DeploymentPlanBuilderImpl
implements UndeployDeploymentPlanBuilder {
    private final DeploymentAction undeployModification;

    UndeployDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan, boolean replace) {
        super(existing, setPlan, replace);
        DeploymentAction modification = setPlan.getLastAction();
        if (modification.getType() != DeploymentAction.Type.UNDEPLOY) {
            throw new IllegalStateException("Invalid action type " + (Object)((Object)modification.getType()));
        }
        this.undeployModification = modification;
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        return super.toServerGroup(serverGroupName);
    }

    @Override
    public RemoveDeploymentPlanBuilder andRemoveUndeployed() {
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveAction(this.undeployModification.getDeploymentUnitUniqueName());
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        boolean add = currentSet.hasServerGroupPlans();
        DeploymentSetPlanImpl newSet = add ? new DeploymentSetPlanImpl() : currentSet;
        newSet = newSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl(this, newSet, !add);
    }
}

