/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.ee;

import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.ee.Element;
import org.jboss.as.metadata.parser.ee.ResourceInjectionTargetMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

public class ResourceInjectionMetaDataParser
extends MetaDataElementParser {
    public static boolean parse(XMLStreamReader reader, ResourceInjectionMetaData resourceInjection) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case LOOKUP_NAME: {
                resourceInjection.setLookupName(reader.getElementText());
                break;
            }
            case MAPPED_NAME: {
                resourceInjection.setMappedName(reader.getElementText());
                break;
            }
            case JNDI_NAME: {
                resourceInjection.setJndiName(reader.getElementText());
                break;
            }
            case IGNORE_DEPENDECY: {
                resourceInjection.setIgnoreDependency(new EmptyMetaData());
                break;
            }
            case INJECTION_TARGET: {
                HashSet<ResourceInjectionTargetMetaData> injectionTargets = resourceInjection.getInjectionTargets();
                if (injectionTargets == null) {
                    injectionTargets = new HashSet<ResourceInjectionTargetMetaData>();
                    resourceInjection.setInjectionTargets(injectionTargets);
                }
                injectionTargets.add(ResourceInjectionTargetMetaDataParser.parse(reader));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

