/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.jbossweb;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.jbossweb.Attribute;
import org.jboss.as.metadata.parser.jbossweb.Element;
import org.jboss.as.metadata.parser.jbossweb.JBossAnnotationMetaDataParser;
import org.jboss.as.metadata.parser.jbossweb.Location;
import org.jboss.as.metadata.parser.jbossweb.Version;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBoss4xDTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50DTDWebMetaData;
import org.jboss.metadata.web.jboss.JBoss50WebMetaData;
import org.jboss.metadata.web.jboss.JBoss60WebMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class JBossWebMetaDataParser
extends MetaDataElementParser {
    public static JBossWebMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            if (reader.getEventType() != 11) continue;
            String dtdLocation = JBossWebMetaDataParser.readDTDLocation(reader);
            if (dtdLocation != null) {
                version = Location.getVersion(dtdLocation);
            }
            if (version != null) continue;
            version = Version.JBOSS_WEB_5_0;
        }
        String schemaLocation = JBossWebMetaDataParser.readSchemaLocation(reader);
        if (schemaLocation != null) {
            version = Location.getVersion(schemaLocation);
        }
        if (version == null) {
            version = Version.JBOSS_WEB_6_0;
        }
        JBoss4xDTDWebMetaData wmd = null;
        switch (version) {
            case JBOSS_WEB_3_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_3_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_0: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_4_2: {
                wmd = new JBoss4xDTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_0: {
                wmd = new JBoss50DTDWebMetaData();
                break;
            }
            case JBOSS_WEB_5_1: {
                wmd = new JBoss50WebMetaData();
                break;
            }
            case JBOSS_WEB_6_0: {
                wmd = new JBoss60WebMetaData();
            }
        }
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    wmd.setVersion(value);
                    continue block18;
                }
                default: {
                    throw JBossWebMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_ROOT: {
                    wmd.setContextRoot(reader.getElementText());
                    continue block19;
                }
                case VIRTUAL_HOST: {
                    ArrayList<String> virtualHosts = wmd.getVirtualHosts();
                    if (virtualHosts == null) {
                        virtualHosts = new ArrayList<String>();
                        wmd.setVirtualHosts(virtualHosts);
                        virtualHosts.add(reader.getElementText());
                        continue block19;
                    }
                    throw JBossWebMetaDataParser.duplicateNamedElement(reader, Element.VIRTUAL_HOST.toString());
                }
                case ANNOTATION: {
                    JBossAnnotationsMetaData annotations = wmd.getAnnotations();
                    if (annotations == null) {
                        annotations = new JBossAnnotationsMetaData();
                        wmd.setAnnotations(annotations);
                    }
                    annotations.add((MappableMetaData)JBossAnnotationMetaDataParser.parse(reader));
                    continue block19;
                }
            }
            throw JBossWebMetaDataParser.unexpectedElement(reader);
        }
        return wmd;
    }
}

