/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.jbossweb;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.metadata.parser.jbossweb.Element;
import org.jboss.as.metadata.parser.jbossweb.HttpMethodConstraintMetaDataParser;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.EmptyRoleSemanticType;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;

public class ServletSecurityMetaDataParser
extends MetaDataElementParser {
    public static ServletSecurityMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        ServletSecurityMetaData servletSecurity = new ServletSecurityMetaData();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HTTP_METHOD_CONSTRAINT: {
                    ArrayList<HttpMethodConstraintMetaData> httpMethodConstraints = servletSecurity.getHttpMethodConstraints();
                    if (httpMethodConstraints == null) {
                        httpMethodConstraints = new ArrayList<HttpMethodConstraintMetaData>();
                        servletSecurity.setHttpMethodConstraints(httpMethodConstraints);
                    }
                    httpMethodConstraints.add(HttpMethodConstraintMetaDataParser.parse(reader));
                    continue block6;
                }
                case EMPTY_ROLE_SEMANTIC: {
                    servletSecurity.setEmptyRoleSemantic(EmptyRoleSemanticType.valueOf((String)reader.getElementText()));
                    continue block6;
                }
                case TRANSPORT_GUARANTEE: {
                    servletSecurity.setTransportGuarantee(TransportGuaranteeType.valueOf((String)reader.getElementText()));
                    continue block6;
                }
                case ROLE_ALLOWED: {
                    ArrayList<String> rolesAllowed = servletSecurity.getRolesAllowed();
                    if (rolesAllowed == null) {
                        rolesAllowed = new ArrayList<String>();
                        servletSecurity.setRolesAllowed(rolesAllowed);
                    }
                    rolesAllowed.add(reader.getElementText());
                    continue block6;
                }
            }
            throw ServletSecurityMetaDataParser.unexpectedElement(reader);
        }
        return servletSecurity;
    }
}

