/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.metadata.parser.servlet;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.as.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.as.metadata.parser.servlet.Attribute;
import org.jboss.as.metadata.parser.servlet.Element;
import org.jboss.as.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;

public class WebResourceCollectionMetaDataParser
extends MetaDataElementParser {
    public static WebResourceCollectionMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        WebResourceCollectionMetaData webResourceCollection = new WebResourceCollectionMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    webResourceCollection.setId(value);
                    continue block9;
                }
                default: {
                    throw WebResourceCollectionMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (webResourceCollection.getDescriptions() != null) continue;
                webResourceCollection.setDescriptions((Descriptions)descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WEB_RESOURCE_NAME: {
                    webResourceCollection.setWebResourceName(reader.getElementText());
                    continue block10;
                }
                case URL_PATTERN: {
                    ArrayList<String> urlPatterns = webResourceCollection.getUrlPatterns();
                    if (urlPatterns == null) {
                        urlPatterns = new ArrayList<String>();
                        webResourceCollection.setUrlPatterns(urlPatterns);
                    }
                    urlPatterns.add(reader.getElementText());
                    continue block10;
                }
                case HTTP_METHOD: {
                    ArrayList<String> httpMethods = webResourceCollection.getHttpMethods();
                    if (httpMethods == null) {
                        httpMethods = new ArrayList<String>();
                        webResourceCollection.setHttpMethods(httpMethods);
                    }
                    httpMethods.add(reader.getElementText());
                    continue block10;
                }
                case HTTP_METHOD_OMISSION: {
                    ArrayList<String> httpMethodOmissions = webResourceCollection.getHttpMethodOmissions();
                    if (httpMethodOmissions == null) {
                        httpMethodOmissions = new ArrayList<String>();
                        webResourceCollection.setHttpMethodOmissions(httpMethodOmissions);
                    }
                    httpMethodOmissions.add(reader.getElementText());
                    continue block10;
                }
            }
            throw WebResourceCollectionMetaDataParser.unexpectedElement(reader);
        }
        return webResourceCollection;
    }
}

