/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.chain.DeploymentChainImpl;
import org.jboss.as.deployment.chain.DeploymentChainProcessorInjector;
import org.jboss.as.deployment.chain.DeploymentChainProvider;
import org.jboss.as.deployment.chain.DeploymentChainProviderInjector;
import org.jboss.as.deployment.chain.DeploymentChainProviderService;
import org.jboss.as.deployment.chain.DeploymentChainService;
import org.jboss.as.deployment.module.DeploymentModuleLoader;
import org.jboss.as.deployment.module.DeploymentModuleLoaderProcessor;
import org.jboss.as.deployment.module.DeploymentModuleLoaderService;
import org.jboss.as.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.naming.ModuleContextProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitProcessorService;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.SharedWebMetaDataBuilder;
import org.jboss.as.web.deployment.JBossWebParsingDeploymentProcessor;
import org.jboss.as.web.deployment.TldParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WarAnnotationDeploymentProcessor;
import org.jboss.as.web.deployment.WarAnnotationIndexProcessor;
import org.jboss.as.web.deployment.WarClassloadingDependencyProcessor;
import org.jboss.as.web.deployment.WarDeploymentProcessor;
import org.jboss.as.web.deployment.WarMetaDataProcessor;
import org.jboss.as.web.deployment.WarModuleConfigProcessor;
import org.jboss.as.web.deployment.WarStructureDeploymentProcessor;
import org.jboss.as.web.deployment.WebFragmentParsingDeploymentProcessor;
import org.jboss.as.web.deployment.WebParsingDeploymentProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;
import org.jboss.vfs.VirtualFile;

class WebDeploymentActivator {
    public static final long WAR_DEPLOYMENT_CHAIN_PRIORITY = 100000L;
    public static final ServiceName WAR_DEPLOYMENT_CHAIN_SERVICE_NAME = DeploymentChain.SERVICE_NAME.append(new String[]{"war"});

    WebDeploymentActivator() {
    }

    static void activate(String defaultHost, SharedWebMetaDataBuilder sharedWebBuilder, SharedTldsMetaDataBuilder sharedTldsBuilder, BatchBuilder batchBuilder) {
        batchBuilder.addServiceValueIfNotExist(DeploymentChainProviderService.SERVICE_NAME, (Value)new DeploymentChainProviderService());
        Value deploymentChainValue = Values.immediateValue((Object)new DeploymentChainImpl(WAR_DEPLOYMENT_CHAIN_SERVICE_NAME.toString()));
        DeploymentChainService deploymentChainService = new DeploymentChainService(deploymentChainValue);
        batchBuilder.addService(WAR_DEPLOYMENT_CHAIN_SERVICE_NAME, (Service)deploymentChainService).addDependency(DeploymentChainProviderService.SERVICE_NAME, DeploymentChainProvider.class, (Injector)new DeploymentChainProviderInjector(deploymentChainValue, (DeploymentChainProvider.Selector)new WarDeploymentChainSelector(), 100000L));
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new ModuleDependencyProcessor(), ModuleDependencyProcessor.PRIORITY);
        InjectedValue moduleLoaderInjector = new InjectedValue();
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new DeploymentModuleLoaderProcessor((Value)moduleLoaderInjector), DeploymentModuleLoaderProcessor.PRIORITY).addDependency(DeploymentModuleLoaderService.SERVICE_NAME, DeploymentModuleLoader.class, (Injector)moduleLoaderInjector);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new ModuleDeploymentProcessor(), ModuleDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new ModuleContextProcessor(), ModuleContextProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarStructureDeploymentProcessor(sharedWebBuilder.create(), sharedTldsBuilder.create()), WarStructureDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarAnnotationIndexProcessor(), WarAnnotationIndexProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarModuleConfigProcessor(), WarModuleConfigProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WebParsingDeploymentProcessor(), WebParsingDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WebFragmentParsingDeploymentProcessor(), WebFragmentParsingDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new JBossWebParsingDeploymentProcessor(), JBossWebParsingDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new TldParsingDeploymentProcessor(), TldParsingDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarClassloadingDependencyProcessor(), WarClassloadingDependencyProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarAnnotationDeploymentProcessor(), WarAnnotationDeploymentProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarMetaDataProcessor(), WarMetaDataProcessor.PRIORITY);
        WebDeploymentActivator.addDeploymentProcessor(batchBuilder, new WarDeploymentProcessor(defaultHost), WarDeploymentProcessor.PRIORITY);
    }

    static <T extends DeploymentUnitProcessor> BatchServiceBuilder<T> addDeploymentProcessor(BatchBuilder batchBuilder, T deploymentUnitProcessor, long priority) {
        DeploymentUnitProcessorService deploymentUnitProcessorService = new DeploymentUnitProcessorService(deploymentUnitProcessor);
        return batchBuilder.addService(WAR_DEPLOYMENT_CHAIN_SERVICE_NAME.append(new String[]{deploymentUnitProcessor.getClass().getName()}), (Service)deploymentUnitProcessorService).addDependency(WAR_DEPLOYMENT_CHAIN_SERVICE_NAME, DeploymentChain.class, (Injector)new DeploymentChainProcessorInjector((Value)deploymentUnitProcessorService, priority));
    }

    public static class WarDeploymentChainSelector
    implements DeploymentChainProvider.Selector {
        static final String WAR_EXTENSION = ".war";

        public boolean supports(DeploymentUnitContext deploymentUnitContext) {
            VirtualFile virtualFile = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)deploymentUnitContext);
            return virtualFile.getName().toLowerCase().endsWith(WAR_EXTENSION);
        }
    }
}

