/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.web.Attribute;
import org.jboss.as.web.Element;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorElement;
import org.jboss.as.web.WebContainerConfigElement;
import org.jboss.as.web.WebSubsystemAdd;
import org.jboss.as.web.WebVirtualHostAdd;
import org.jboss.as.web.WebVirtualHostElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class WebSubsystemElement
extends AbstractSubsystemElement<WebSubsystemElement> {
    private static final long serialVersionUID = 4287677532426993047L;
    public static final ServiceName JBOSS_WEB = ServiceName.JBOSS.append(new String[]{"web"});
    public static final ServiceName JBOSS_WEB_SERVER = JBOSS_WEB.append(new String[]{"server"});
    public static final ServiceName JBOSS_WEB_CONNECTOR = JBOSS_WEB.append(new String[]{"connector"});
    public static final ServiceName JBOSS_WEB_HOST = JBOSS_WEB.append(new String[]{"host"});
    private String defaultHost;
    private WebContainerConfigElement config;
    private final NavigableMap<String, WebConnectorElement> connectors = new TreeMap<String, WebConnectorElement>();
    private final NavigableMap<String, WebVirtualHostElement> hosts = new TreeMap<String, WebVirtualHostElement>();

    protected WebSubsystemElement(String defaultHost) {
        super(Namespace.CURRENT.getUriString());
        this.defaultHost = defaultHost;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<WebSubsystemElement, ?>> list) {
        for (WebConnectorElement connector : this.connectors.values()) {
            list.add(WebConnectorAdd.create(connector));
        }
        for (WebVirtualHostElement host : this.hosts.values()) {
            list.add(WebVirtualHostAdd.create(host));
        }
    }

    protected boolean isEmpty() {
        return this.connectors.isEmpty() && this.hosts.isEmpty();
    }

    protected AbstractSubsystemAdd<WebSubsystemElement> getAdd() {
        WebSubsystemAdd action = new WebSubsystemAdd();
        action.setDefaultHost(this.defaultHost);
        action.setConfig(this.config);
        return action;
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = updateContext.getServiceContainer().getService(JBOSS_WEB);
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    protected Class<WebSubsystemElement> getElementClass() {
        return WebSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.defaultHost != null) {
            streamWriter.writeAttribute(Attribute.DEFAULT_HOST.getLocalName(), this.defaultHost);
        }
        if (this.config != null) {
            streamWriter.writeStartElement(Element.CONTAINER_CONFIG.getLocalName());
            this.config.writeContent(streamWriter);
        }
        if (!this.connectors.isEmpty()) {
            for (WebConnectorElement connector : this.connectors.values()) {
                streamWriter.writeStartElement(Element.CONNECTOR.getLocalName());
                connector.writeContent(streamWriter);
            }
        }
        if (!this.hosts.isEmpty()) {
            for (WebVirtualHostElement host : this.hosts.values()) {
                streamWriter.writeStartElement(Element.VIRTUAL_SERVER.getLocalName());
                host.writeContent(streamWriter);
            }
        }
        streamWriter.writeEndElement();
    }

    public WebContainerConfigElement getConfig() {
        return this.config;
    }

    public void setConfig(WebContainerConfigElement config) {
        this.config = config;
    }

    WebConnectorElement addConnector(String name) {
        if (this.connectors.containsKey(name)) {
            return null;
        }
        WebConnectorElement connector = new WebConnectorElement(name);
        this.connectors.put(name, connector);
        return connector;
    }

    public WebConnectorElement getConnector(String name) {
        return (WebConnectorElement)((Object)this.connectors.get(name));
    }

    boolean removeConnector(String name) {
        return this.connectors.remove(name) != null;
    }

    WebVirtualHostElement addHost(String name) {
        if (this.hosts.containsKey(name)) {
            return null;
        }
        WebVirtualHostElement host = new WebVirtualHostElement(name);
        this.hosts.put(name, host);
        return host;
    }

    public WebVirtualHostElement getHost(String name) {
        return (WebVirtualHostElement)((Object)this.hosts.get(name));
    }

    boolean removeHost(String name) {
        return this.hosts.remove(name) != null;
    }
}

