/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarAnnotationIndex;
import org.jboss.as.web.deployment.WarAnnotationIndexProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
import org.jboss.metadata.annotation.creator.web.MultipartConfigProcessor;
import org.jboss.metadata.annotation.creator.web.RunAsProcessor;
import org.jboss.metadata.annotation.creator.web.ServletSecurityProcessor;
import org.jboss.metadata.annotation.creator.web.WebFilterProcessor;
import org.jboss.metadata.annotation.creator.web.WebListenerProcessor;
import org.jboss.metadata.annotation.creator.web.WebServletProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.annotation.finder.DefaultAnnotationFinder;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.spec.AnnotationsMetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class WarAnnotationDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.POST_MODULE_DESCRIPTORS.plus(300L);
    private static final DotName webFilter = DotName.createSimple((String)WebFilter.class.getName());
    private static final DotName webListener = DotName.createSimple((String)WebListener.class.getName());
    private static final DotName webServlet = DotName.createSimple((String)WebServlet.class.getName());
    private static final DotName runAs = DotName.createSimple((String)RunAs.class.getName());
    private static final DotName declareRoles = DotName.createSimple((String)DeclareRoles.class.getName());
    private static final DotName multipartConfig = DotName.createSimple((String)MultipartConfig.class.getName());
    private static final DotName servletSecurity = DotName.createSimple((String)ServletSecurity.class.getName());

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        Module module;
        WarAnnotationIndex index = (WarAnnotationIndex)context.getAttachment(WarAnnotationIndexProcessor.ATTACHMENT_KEY);
        if (index == null) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)context.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Map<String, WebMetaData> annotationsMetaData = warMetaData.getAnnotationsMetaData();
        if (annotationsMetaData == null) {
            annotationsMetaData = new HashMap<String, WebMetaData>();
            warMetaData.setAnnotationsMetaData(annotationsMetaData);
        }
        if ((module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY)) == null) {
            throw new DeploymentUnitProcessingException("failed to resolve module for deployment " + context.getName());
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        if (index.getRootIndex() != null) {
            annotationsMetaData.put("", this.processAnnotations(index.getRootIndex(), (ClassLoader)classLoader));
        }
        for (String pathName : index.getPathNames()) {
            Index jarIndex = index.getIndex(pathName);
            annotationsMetaData.put(pathName, this.processAnnotations(jarIndex, (ClassLoader)classLoader));
        }
    }

    protected WebMetaData processAnnotations(Index index, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        List servletSecurityAnnotationTargets;
        List multipartConfigAnnotationTargets;
        List declareRolesAnnotationTargets;
        List runAsAnnotationTargets;
        List webListenerAnnotationTargets;
        List webFilterAnnotationTargets;
        Web30MetaData metaData = new Web30MetaData();
        DefaultAnnotationFinder finder = new DefaultAnnotationFinder();
        List webServletAnnotationTargets = index.getAnnotationTargets(webServlet);
        if (webServletAnnotationTargets != null && webServletAnnotationTargets.size() > 0) {
            WebServletProcessor processor = new WebServletProcessor((AnnotationFinder)finder);
            for (AnnotationTarget target : webServletAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@WebServlet is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @WebServlet on " + target);
                }
                if (type == null) continue;
                processor.process((WebMetaData)metaData, type);
            }
        }
        if ((webFilterAnnotationTargets = index.getAnnotationTargets(webFilter)) != null && webFilterAnnotationTargets.size() > 0) {
            WebFilterProcessor processor = new WebFilterProcessor((AnnotationFinder)finder);
            for (AnnotationTarget target : webFilterAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@WebFilter is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @WebFilter on " + target);
                }
                if (type == null) continue;
                processor.process((WebMetaData)metaData, type);
            }
        }
        if ((webListenerAnnotationTargets = index.getAnnotationTargets(webListener)) != null && webListenerAnnotationTargets.size() > 0) {
            WebListenerProcessor processor = new WebListenerProcessor((AnnotationFinder)finder);
            for (AnnotationTarget target : webListenerAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@WebListener is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @WebListener on " + target);
                }
                if (type == null) continue;
                processor.process((WebMetaData)metaData, type);
            }
        }
        if ((runAsAnnotationTargets = index.getAnnotationTargets(runAs)) != null && runAsAnnotationTargets.size() > 0) {
            RunAsProcessor processor = new RunAsProcessor((AnnotationFinder)finder);
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationTarget target : runAsAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@RunAs is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @RunAs on " + target);
                }
                if (type == null) continue;
                processor.process(annotations, type);
            }
        }
        if ((declareRolesAnnotationTargets = index.getAnnotationTargets(declareRoles)) != null && declareRolesAnnotationTargets.size() > 0) {
            DeclareRolesProcessor processor = new DeclareRolesProcessor((AnnotationFinder)finder);
            SecurityRolesMetaData securityRoles = metaData.getSecurityRoles();
            if (securityRoles == null) {
                securityRoles = new SecurityRolesMetaData();
                metaData.setSecurityRoles(securityRoles);
            }
            for (AnnotationTarget target : declareRolesAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@DeclareRoles is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @DeclareRoles on " + target);
                }
                if (type == null) continue;
                processor.process(securityRoles, type);
            }
        }
        if ((multipartConfigAnnotationTargets = index.getAnnotationTargets(multipartConfig)) != null && multipartConfigAnnotationTargets.size() > 0) {
            MultipartConfigProcessor processor = new MultipartConfigProcessor((AnnotationFinder)finder);
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationTarget target : multipartConfigAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@MultipartConfig is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @MultipartConfig on " + target);
                }
                if (type == null) continue;
                processor.process(annotations, type);
            }
        }
        if ((servletSecurityAnnotationTargets = index.getAnnotationTargets(servletSecurity)) != null && servletSecurityAnnotationTargets.size() > 0) {
            ServletSecurityProcessor processor = new ServletSecurityProcessor((AnnotationFinder)finder);
            AnnotationsMetaData annotations = metaData.getAnnotations();
            if (annotations == null) {
                annotations = new AnnotationsMetaData();
                metaData.setAnnotations(annotations);
            }
            for (AnnotationTarget target : servletSecurityAnnotationTargets) {
                if (!(target instanceof ClassInfo)) {
                    throw new DeploymentUnitProcessingException("@ServletSecurity is only allowed at class level " + target);
                }
                ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
                Class<?> type = null;
                try {
                    type = classLoader.loadClass(classInfo.name().toString());
                }
                catch (Exception e) {
                    throw new DeploymentUnitProcessingException("Could not process @ServletSecurity on " + target);
                }
                if (type == null) continue;
                processor.process(annotations, type);
            }
        }
        return metaData;
    }
}

