/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.as.deployment.module.TempFileProviderService;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.helpers.DeploymentStructure;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class WarStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.VALIDATE.plus(300L);
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private final WebMetaData sharedWebMetaData;
    private final List<TldMetaData> sharedTldsMetaData;

    public WarStructureDeploymentProcessor(WebMetaData sharedWebMetaData, List<TldMetaData> sharedTldsMetaData) {
        this.sharedWebMetaData = sharedWebMetaData;
        this.sharedTldsMetaData = sharedTldsMetaData;
    }

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        if (deploymentRoot == null) {
            return;
        }
        MountHandle mountHandle = (MountHandle)context.getAttachment(MountHandle.ATTACHMENT_KEY);
        try {
            DeploymentStructure.ClassPathEntry[] entries = this.createResourceRoots(deploymentRoot, mountHandle);
            DeploymentStructure structure = new DeploymentStructure(entries);
            context.putAttachment(DeploymentStructure.ATTACHMENT_KEY, (Object)structure);
            BatchBuilder builder = context.getBatchBuilder();
            ServiceName sName = ServiceName.JBOSS.append(new String[]{"deployment", context.getName(), "structure"});
            builder.addService(sName, (Service)new DeploymentStructureService(structure));
            builder.addDependency(sName);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        WarMetaData warMetaData = new WarMetaData();
        warMetaData.setSharedWebMetaData(this.sharedWebMetaData);
        context.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMetaData);
        TldsMetaData tldsMetaData = new TldsMetaData();
        tldsMetaData.setSharedTlds(this.sharedTldsMetaData);
        context.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
    }

    DeploymentStructure.ClassPathEntry[] createResourceRoots(VirtualFile deploymentRoot, MountHandle mountHandle) throws IOException, DeploymentUnitProcessingException {
        ArrayList<DeploymentStructure.ClassPathEntry> entries = new ArrayList<DeploymentStructure.ClassPathEntry>();
        entries.add(new DeploymentStructure.ClassPathEntry(deploymentRoot.getChild(WEB_INF_CLASSES), null));
        this.createWebInfLibResources(deploymentRoot, entries);
        return entries.toArray(new DeploymentStructure.ClassPathEntry[entries.size()]);
    }

    void createWebInfLibResources(VirtualFile deploymentRoot, List<DeploymentStructure.ClassPathEntry> entries) throws IOException, DeploymentUnitProcessingException {
        VirtualFile webinfLib = deploymentRoot.getChild(WEB_INF_LIB);
        if (webinfLib.exists()) {
            List archives = webinfLib.getChildren(DEFAULT_WEB_INF_LIB_FILTER);
            for (VirtualFile archive : archives) {
                try {
                    Closeable closable = VFS.mountZip((VirtualFile)archive, (VirtualFile)archive, (TempFileProvider)TempFileProviderService.provider());
                    entries.add(new DeploymentStructure.ClassPathEntry(archive, closable));
                }
                catch (IOException e) {
                    throw new DeploymentUnitProcessingException("failed to process " + archive, (Throwable)e);
                }
            }
        }
    }

    static class DeploymentStructureService
    implements Service<Void> {
        final DeploymentStructure structure;

        public DeploymentStructureService(DeploymentStructure structure) {
            this.structure = structure;
        }

        public Void getValue() throws IllegalStateException {
            return null;
        }

        public void start(StartContext context) throws StartException {
        }

        public void stop(StopContext context) {
            for (DeploymentStructure.ClassPathEntry entry : this.structure.getEntries()) {
                try {
                    entry.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        }
    }
}

