/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.standalone.client.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Future;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.standalone.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentPlanResult;
import org.jboss.as.standalone.client.impl.StandaloneClientImpl;
import org.jboss.as.standalone.client.impl.deployment.DeploymentContentDistributor;
import org.jboss.as.standalone.client.impl.deployment.InitialDeploymentPlanBuilderFactory;

class StandaloneClientDeploymentManager
implements ServerDeploymentManager {
    private final StandaloneClientImpl client;
    private final DeploymentContentDistributor contentDistributor;

    StandaloneClientDeploymentManager(StandaloneClientImpl client) {
        assert (client != null) : "client is null";
        this.client = client;
        this.contentDistributor = new DeploymentContentDistributor(){

            @Override
            public byte[] distributeDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
                boolean unique = StandaloneClientDeploymentManager.this.client.isDeploymentNameUnique(name);
                if (!unique) {
                    throw new DuplicateDeploymentNameException(name, false);
                }
                return StandaloneClientDeploymentManager.this.client.addDeploymentContent(name, runtimeName, stream);
            }

            @Override
            public byte[] distributeReplacementDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
                return StandaloneClientDeploymentManager.this.client.addDeploymentContent(name, runtimeName, stream);
            }
        };
    }

    @Override
    public String addDeploymentContent(File file) throws IOException, DuplicateDeploymentNameException {
        String name = file.getName();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, name, new FileInputStream(file));
        return name;
    }

    @Override
    public String addDeploymentContent(URL url) throws IOException, DuplicateDeploymentNameException {
        String name = StandaloneClientDeploymentManager.getName(url);
        this.addDeploymentContent(name, name, url);
        return name;
    }

    @Override
    public void addDeploymentContent(String name, File file) throws IOException, DuplicateDeploymentNameException {
        String commonName = file.getName();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, new FileInputStream(file));
    }

    @Override
    public void addDeploymentContent(String name, URL url) throws IOException, DuplicateDeploymentNameException {
        String commonName = StandaloneClientDeploymentManager.getName(url);
        this.addDeploymentContent(name, commonName, url);
    }

    private void addDeploymentContent(String name, String commonName, URL url) throws IOException, DuplicateDeploymentNameException {
        URLConnection conn = url.openConnection();
        conn.connect();
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, conn.getInputStream());
    }

    @Override
    public void addDeploymentContent(String name, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        this.addDeploymentContent(name, name, stream);
    }

    @Override
    public void addDeploymentContent(String name, String commonName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        this.getDeploymentContentDistributor().distributeDeploymentContent(name, commonName, stream);
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder(this.contentDistributor);
    }

    @Override
    public Future<ServerDeploymentPlanResult> execute(DeploymentPlan plan) {
        return this.client.execute(plan);
    }

    DeploymentContentDistributor getDeploymentContentDistributor() {
        return this.contentDistributor;
    }

    private static String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(url + " is not a valid URI", e);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            throw new IllegalArgumentException("Cannot derive a deployment name from " + url + " -- use an overloaded method variant that takes a 'name' parameter");
        }
        return path.substring(idx + 1);
    }
}

