/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.standalone.client.impl;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.StandaloneUpdateResult;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentPlanResult;
import org.jboss.as.standalone.client.impl.StandaloneClientDeploymentManager;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;

public class StandaloneClientImpl
implements StandaloneClient {
    private static final MarshallingConfiguration CONFIG = new MarshallingConfiguration();
    private static final long CONNECTION_TIMEOUT;
    private final InetAddress address;
    private final int port;
    private final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private final ExecutorService executorService = Executors.newCachedThreadPool(this.threadFactory);

    public StandaloneClientImpl(InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public ServerModel getServerModel() {
        try {
            return (ServerModel)new GetServerModel().executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to get server model.", (Throwable)e);
        }
    }

    @Override
    public List<StandaloneUpdateResult<?>> applyUpdates(List<AbstractServerModelUpdate<?>> updates) {
        try {
            return (List)new ApplyUpdatesOperation(updates).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to apply server module updates.", (Throwable)e);
        }
    }

    @Override
    public byte[] addDeploymentContent(String name, String runtimeName, InputStream stream) {
        try {
            return (byte[])new AddDeploymentContentOperation(name, runtimeName, stream).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to add deployment content.", (Throwable)e);
        }
    }

    @Override
    public ServerDeploymentManager getDeploymentManager() {
        return new StandaloneClientDeploymentManager(this);
    }

    Future<ServerDeploymentPlanResult> execute(DeploymentPlan plan) {
        try {
            return new ExecuteDeploymentPlanOperation(plan).execute(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute deployment plan", e);
        }
    }

    boolean isDeploymentNameUnique(String name) {
        try {
            return (Boolean)new CheckUnitDeploymentNameOperation(name).executeForResult(this.getConnectionStrategy());
        }
        catch (Exception e) {
            throw new ManagementException("Failed to check deployment name uniqueness.", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
    }

    private static Marshaller getMarshaller() throws IOException {
        return ProtocolUtils.getMarshaller((MarshallingConfiguration)CONFIG);
    }

    private static Unmarshaller getUnmarshaller() throws IOException {
        return ProtocolUtils.getUnmarshaller((MarshallingConfiguration)CONFIG);
    }

    private ManagementRequestConnectionStrategy getConnectionStrategy() {
        return new ManagementRequestConnectionStrategy.EstablishConnectingStrategy(this.address, this.port, CONNECTION_TIMEOUT, this.executorService, this.threadFactory);
    }

    static {
        CONFIG.setClassResolver((ClassResolver)new SimpleClassResolver(StandaloneClientImpl.class.getClassLoader()));
        CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    }

    private class CheckUnitDeploymentNameOperation
    extends StandaloneClientRequest<Boolean> {
        private final String deploymentName;

        private CheckUnitDeploymentNameOperation(String name) {
            this.deploymentName = name;
        }

        public final byte getRequestCode() {
            return 98;
        }

        protected final byte getResponseCode() {
            return 100;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(86);
                output.writeUTF(this.deploymentName);
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Boolean receiveResponse(InputStream inputStream) throws IOException {
            Boolean bl;
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)99);
                bl = input.readBoolean();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
            return bl;
        }
    }

    private class ExecuteDeploymentPlanOperation
    extends StandaloneClientRequest<ServerDeploymentPlanResult> {
        private final DeploymentPlan deploymentPlan;

        private ExecuteDeploymentPlanOperation(DeploymentPlan deploymentPlan) {
            this.deploymentPlan = deploymentPlan;
        }

        public final byte getRequestCode() {
            return 81;
        }

        protected final byte getResponseCode() {
            return 84;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = StandaloneClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(82);
            marshaller.writeObject((Object)this.deploymentPlan);
            marshaller.finish();
        }

        protected final ServerDeploymentPlanResult receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = StandaloneClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)83);
            ServerDeploymentPlanResult result = (ServerDeploymentPlanResult)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerDeploymentPlanResult.class);
            unmarshaller.finish();
            return result;
        }
    }

    private class AddDeploymentContentOperation
    extends StandaloneClientRequest<byte[]> {
        private final String name;
        private final String runtimeName;
        private final InputStream inputStream;

        private AddDeploymentContentOperation(String name, String runtimeName, InputStream inputStream) {
            this.name = name;
            this.runtimeName = runtimeName;
            this.inputStream = inputStream;
        }

        public final byte getRequestCode() {
            return 85;
        }

        protected final byte getResponseCode() {
            return 97;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream outputStream) throws IOException {
            outputStream.write(86);
            StreamUtils.writeUTFZBytes((OutputStream)outputStream, (String)this.name);
            outputStream.write(87);
            StreamUtils.writeUTFZBytes((OutputStream)outputStream, (String)this.runtimeName);
            outputStream.write(88);
            try {
                int read;
                byte[] buffer = new byte[8192];
                while ((read = this.inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, read);
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)this.inputStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final byte[] receiveResponse(InputStream inputStream) throws IOException {
            byte[] byArray;
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)89);
                int length = input.readInt();
                byte[] hash = new byte[length];
                ProtocolUtils.expectHeader((DataInput)input, (int)96);
                input.readFully(hash);
                byArray = hash;
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
            return byArray;
        }
    }

    private class ApplyUpdatesOperation
    extends StandaloneClientRequest<List<StandaloneUpdateResult<?>>> {
        private final List<AbstractServerModelUpdate<?>> updates;

        public ApplyUpdatesOperation(List<AbstractServerModelUpdate<?>> updates) {
            this.updates = updates;
        }

        protected byte getRequestCode() {
            return 69;
        }

        protected byte getResponseCode() {
            return 80;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            Marshaller marshaller = StandaloneClientImpl.getMarshaller();
            marshaller.start(Marshalling.createByteOutput((OutputStream)output));
            marshaller.writeByte(70);
            marshaller.writeInt(this.updates.size());
            for (AbstractServerModelUpdate<?> update : this.updates) {
                marshaller.writeByte(105);
                marshaller.writeObject(update);
            }
            marshaller.finish();
        }

        protected List<StandaloneUpdateResult<?>> receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = StandaloneClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)70);
            int updateCount = unmarshaller.readInt();
            ArrayList results = new ArrayList();
            for (int i = 0; i < updateCount; ++i) {
                ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)72);
                byte resultCode = unmarshaller.readByte();
                if (resultCode == 73) {
                    UpdateFailedException failure = (UpdateFailedException)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, UpdateFailedException.class);
                    results.add(new StandaloneUpdateResult<Object>(null, failure));
                    continue;
                }
                Object result = ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, Object.class);
                results.add(new StandaloneUpdateResult<Object>(result, null));
            }
            return results;
        }
    }

    private class GetServerModel
    extends StandaloneClientRequest<ServerModel> {
        private GetServerModel() {
        }

        protected byte getRequestCode() {
            return 118;
        }

        protected byte getResponseCode() {
            return 119;
        }

        protected ServerModel receiveResponse(InputStream input) throws IOException {
            Unmarshaller unmarshaller = StandaloneClientImpl.getUnmarshaller();
            unmarshaller.start(Marshalling.createByteInput((InputStream)input));
            ProtocolUtils.expectHeader((DataInput)unmarshaller, (int)120);
            ServerModel serverModel = (ServerModel)ProtocolUtils.unmarshal((Unmarshaller)unmarshaller, ServerModel.class);
            unmarshaller.finish();
            return serverModel;
        }
    }

    abstract class StandaloneClientRequest<T>
    extends ManagementRequest<T> {
        StandaloneClientRequest() {
        }

        protected byte getHandlerId() {
            return 117;
        }
    }
}

