/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.standalone.client.impl.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.standalone.client.api.deployment.AddDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.DeploymentAction;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.DuplicateDeploymentNameException;
import org.jboss.as.standalone.client.api.deployment.InitialDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.ReplaceDeploymentPlanBuilder;
import org.jboss.as.standalone.client.api.deployment.UndeployDeploymentPlanBuilder;
import org.jboss.as.standalone.client.impl.deployment.DeploymentActionImpl;
import org.jboss.as.standalone.client.impl.deployment.DeploymentContentDistributor;
import org.jboss.as.standalone.client.impl.deployment.DeploymentPlanImpl;
import org.jboss.as.standalone.client.impl.deployment.ReplaceDeploymentPlanBuilderImpl;

class DeploymentPlanBuilderImpl
implements AddDeploymentPlanBuilder,
InitialDeploymentPlanBuilder,
UndeployDeploymentPlanBuilder {
    private final DeploymentContentDistributor deploymentDistributor;
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;
    private final boolean globalRollback;
    private final List<DeploymentActionImpl> deploymentActions = new ArrayList<DeploymentActionImpl>();

    DeploymentPlanBuilderImpl(DeploymentContentDistributor deploymentDistributor) {
        if (deploymentDistributor == null) {
            throw new IllegalArgumentException("deploymentDistributor is null");
        }
        this.deploymentDistributor = deploymentDistributor;
        this.shutdown = false;
        this.globalRollback = false;
        this.gracefulShutdownPeriod = -1L;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.deploymentDistributor = existing.deploymentDistributor;
        this.shutdown = existing.shutdown;
        this.globalRollback = existing.globalRollback;
        this.gracefulShutdownPeriod = existing.gracefulShutdownPeriod;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, boolean globalRollback) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.deploymentDistributor = existing.deploymentDistributor;
        this.shutdown = false;
        this.globalRollback = globalRollback;
        this.gracefulShutdownPeriod = -1L;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, long gracefulShutdownPeriod) {
        this.deploymentActions.addAll(existing.deploymentActions);
        this.deploymentDistributor = existing.deploymentDistributor;
        this.shutdown = true;
        this.globalRollback = false;
        this.gracefulShutdownPeriod = gracefulShutdownPeriod;
    }

    DeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentActionImpl modification) {
        this(existing);
        this.deploymentActions.add(modification);
    }

    @Override
    public DeploymentAction getLastAction() {
        return this.deploymentActions.size() == 0 ? null : this.deploymentActions.get(this.deploymentActions.size() - 1);
    }

    @Override
    public List<DeploymentAction> getDeploymentActions() {
        return new ArrayList<DeploymentAction>(this.deploymentActions);
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownPeriod;
    }

    @Override
    public boolean isGlobalRollback() {
        return this.globalRollback;
    }

    @Override
    public boolean isGracefulShutdown() {
        return this.shutdown && this.gracefulShutdownPeriod > -1L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public DeploymentPlan build() {
        return new DeploymentPlanImpl(Collections.unmodifiableList(this.deploymentActions), this.globalRollback, this.shutdown, this.gracefulShutdownPeriod);
    }

    @Override
    public AddDeploymentPlanBuilder add(File file) throws IOException, DuplicateDeploymentNameException {
        String name = file.getName();
        return this.add(name, name, file.toURI().toURL());
    }

    @Override
    public AddDeploymentPlanBuilder add(URL url) throws IOException, DuplicateDeploymentNameException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.add(name, name, url);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, File file) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, file.getName(), file.toURI().toURL());
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, URL url) throws IOException, DuplicateDeploymentNameException {
        String commonName = DeploymentPlanBuilderImpl.getName(url);
        return this.add(name, commonName, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddDeploymentPlanBuilder add(String name, String commonName, URL url) throws IOException, DuplicateDeploymentNameException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            AddDeploymentPlanBuilder addDeploymentPlanBuilder = this.add(name, commonName, stream);
            return addDeploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentPlanBuilder replace(String name, String commonName, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream stream = conn.getInputStream();
        try {
            DeploymentPlanBuilder deploymentPlanBuilder = this.replace(name, commonName, stream);
            return deploymentPlanBuilder;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ignored) {}
        }
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        return this.add(name, name, stream);
    }

    @Override
    public AddDeploymentPlanBuilder add(String name, String commonName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
        byte[] hash = this.deploymentDistributor.distributeDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getAddAction(name, commonName, hash);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder andDeploy() {
        String addedKey = this.getAddedContentKey();
        DeploymentActionImpl deployMod = DeploymentActionImpl.getDeployAction(addedKey);
        return new DeploymentPlanBuilderImpl(this, deployMod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder andReplace(String toReplace) {
        String newContentKey = this.getAddedContentKey();
        return this.replace(newContentKey, toReplace);
    }

    @Override
    public DeploymentPlanBuilder deploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getDeployAction(key);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public UndeployDeploymentPlanBuilder undeploy(String key) {
        DeploymentActionImpl mod = DeploymentActionImpl.getUndeployAction(key);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder redeploy(String deploymentName) {
        DeploymentActionImpl mod = DeploymentActionImpl.getRedeployAction(deploymentName);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public ReplaceDeploymentPlanBuilder replace(String replacement, String toReplace) {
        DeploymentActionImpl mod = DeploymentActionImpl.getReplaceAction(replacement, toReplace);
        return new ReplaceDeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder replace(File file) throws IOException {
        String name = file.getName();
        return this.replace(name, name, file.toURI().toURL());
    }

    @Override
    public DeploymentPlanBuilder replace(URL url) throws IOException {
        String name = DeploymentPlanBuilderImpl.getName(url);
        return this.replace(name, name, url);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, File file) throws IOException {
        return this.replace(name, name, file.toURI().toURL());
    }

    @Override
    public DeploymentPlanBuilder replace(String name, URL url) throws IOException {
        return this.replace(name, name, url);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, InputStream stream) throws IOException {
        return this.replace(name, name, stream);
    }

    @Override
    public DeploymentPlanBuilder replace(String name, String commonName, InputStream stream) throws IOException {
        byte[] hash = this.deploymentDistributor.distributeReplacementDeploymentContent(name, commonName, stream);
        DeploymentActionImpl mod = DeploymentActionImpl.getFullReplaceAction(name, commonName, hash);
        return new DeploymentPlanBuilderImpl(this, mod);
    }

    @Override
    public DeploymentPlanBuilder andRemoveUndeployed() {
        DeploymentAction last = this.getLastAction();
        if (last.getType() != DeploymentAction.Type.UNDEPLOY) {
            throw new IllegalStateException("Preceding action was not a " + (Object)((Object)DeploymentAction.Type.UNDEPLOY));
        }
        DeploymentActionImpl removeMod = DeploymentActionImpl.getRemoveAction(last.getDeploymentUnitUniqueName());
        return new DeploymentPlanBuilderImpl(this, removeMod);
    }

    @Override
    public DeploymentPlanBuilder remove(String key) {
        DeploymentActionImpl removeMod = DeploymentActionImpl.getRemoveAction(key);
        return new DeploymentPlanBuilderImpl(this, removeMod);
    }

    @Override
    public DeploymentPlanBuilder withRollback() {
        if (this.deploymentActions.size() > 0) {
            throw new IllegalStateException(InitialDeploymentPlanBuilder.class.getSimpleName() + " operations are not allowed after content and deployment modifications");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Global rollback is not compatible with a server restart");
        }
        return new DeploymentPlanBuilderImpl(this, true);
    }

    @Override
    public DeploymentPlanBuilder withGracefulShutdown(long timeout, TimeUnit timeUnit) {
        if (this.deploymentActions.size() > 0) {
            throw new IllegalStateException(InitialDeploymentPlanBuilder.class.getSimpleName() + " operations are not allowed after content and deployment modifications");
        }
        if (this.globalRollback) {
            throw new IllegalStateException("Global rollback is not compatible with a server restart");
        }
        long period = timeUnit.toMillis(timeout);
        if (this.shutdown && period != this.gracefulShutdownPeriod) {
            throw new IllegalStateException("Graceful shutdown already configured with a timeout of " + this.gracefulShutdownPeriod + " ms");
        }
        return new DeploymentPlanBuilderImpl(this, period);
    }

    @Override
    public DeploymentPlanBuilder withShutdown() {
        if (this.deploymentActions.size() > 0) {
            throw new IllegalStateException(InitialDeploymentPlanBuilder.class.getSimpleName() + " operations are not allowed after content and deployment modifications");
        }
        if (this.globalRollback) {
            throw new IllegalStateException("Global rollback is not compatible with a server restart");
        }
        if (this.shutdown && this.gracefulShutdownPeriod != -1L) {
            throw new IllegalStateException("Graceful shutdown already configured with a timeout of " + this.gracefulShutdownPeriod + " ms");
        }
        return new DeploymentPlanBuilderImpl(this, -1L);
    }

    private String getAddedContentKey() {
        DeploymentAction last = this.getLastAction();
        if (last.getType() != DeploymentAction.Type.ADD) {
            throw new IllegalStateException("Preceding action was not a " + (Object)((Object)DeploymentAction.Type.ADD));
        }
        return last.getDeploymentUnitUniqueName();
    }

    private static String getName(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                File f = new File(url.toURI());
                return f.getName();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(url + " is not a valid URI", e);
            }
        }
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        while (idx == path.length() - 1) {
            path = path.substring(0, idx);
            idx = path.lastIndexOf(47);
        }
        if (idx == -1) {
            throw new IllegalArgumentException("Cannot derive a deployment name from " + url + " -- use an overloaded method variant that takes a 'name' parameter");
        }
        return path.substring(idx + 1);
    }
}

