/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.standalone.client.impl.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jboss.as.standalone.client.api.deployment.DeploymentAction;
import org.jboss.as.standalone.client.api.deployment.DeploymentPlan;
import org.jboss.as.standalone.client.impl.deployment.DeploymentActionImpl;

public class DeploymentPlanImpl
implements DeploymentPlan {
    private static final long serialVersionUID = -119621318892470668L;
    private final UUID uuid = UUID.randomUUID();
    private final List<DeploymentActionImpl> deploymentActions = new ArrayList<DeploymentActionImpl>();
    private final boolean globalRollback;
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;

    DeploymentPlanImpl(List<DeploymentActionImpl> actions, boolean globalRollback, boolean shutdown, long gracefulTimeout) {
        if (actions == null) {
            throw new IllegalArgumentException("actions is null");
        }
        this.deploymentActions.addAll(actions);
        this.globalRollback = globalRollback;
        this.shutdown = shutdown;
        this.gracefulShutdownPeriod = gracefulTimeout;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public List<DeploymentAction> getDeploymentActions() {
        return new ArrayList<DeploymentAction>(this.deploymentActions);
    }

    @Override
    public boolean isGlobalRollback() {
        return this.globalRollback;
    }

    @Override
    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownPeriod;
    }

    @Override
    public boolean isGracefulShutdown() {
        return this.shutdown && this.gracefulShutdownPeriod > -1L;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    public List<DeploymentActionImpl> getDeploymentActionImpls() {
        return new ArrayList<DeploymentActionImpl>(this.deploymentActions);
    }
}

