/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.mbean;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.ObjectNameFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ManagedServiceContainerService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "service", "container"});
    public static final ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.internal", "mbean", "ServiceContainer");
    private final Logger log = Logger.getLogger(ManagedServiceContainerService.class);
    private final InjectedValue<MBeanServer> injectedMBeanServer = new InjectedValue();
    private ServiceContainer serviceContainer;

    public static void addService(BatchBuilder batchBuilder) {
        ManagedServiceContainerService service = new ManagedServiceContainerService();
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.injectedMBeanServer);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public synchronized void start(StartContext context) throws StartException {
        this.serviceContainer = context.getController().getServiceContainer();
        ManagedServiceContainer mbean = new ManagedServiceContainer(){

            @Override
            public List<String> listServices() {
                return this.getServiceList(null);
            }

            @Override
            public List<String> listServicesByMode(String mode) {
                if (mode == null) {
                    return this.getServiceList(null);
                }
                String pattern = "mode " + ServiceController.Mode.valueOf((String)mode.trim().toUpperCase());
                return this.getServiceList(pattern);
            }

            @Override
            public List<String> listServicesByState(String state) {
                if (state == null) {
                    return this.getServiceList(null);
                }
                String pattern = "state=" + ServiceController.State.valueOf((String)state.trim().toUpperCase());
                return this.getServiceList(pattern);
            }

            @Override
            public void setMode(String name, String mode) {
                if (name == null) {
                    throw new IllegalArgumentException("Null name");
                }
                if (mode == null) {
                    throw new IllegalArgumentException("Null mode");
                }
                ServiceName serviceName = ServiceName.parse((String)name.trim());
                ServiceController controller = ManagedServiceContainerService.this.serviceContainer.getService(serviceName);
                if (controller == null) {
                    throw new IllegalStateException("Cannot obtain service: " + serviceName);
                }
                controller.setMode(ServiceController.Mode.valueOf((String)mode.trim().toUpperCase()));
            }

            private List<String> getServiceList(String pattern) {
                ArrayList<String> entries = new ArrayList<String>();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ManagedServiceContainerService.this.serviceContainer.dumpServices(new PrintStream(baos));
                BufferedReader reader = new BufferedReader(new StringReader(new String(baos.toByteArray())));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        if (pattern == null || line.contains(pattern)) {
                            entries.add(line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException ex) {
                    ManagedServiceContainerService.this.log.errorf((Throwable)ex, "Cannot process service list", new Object[0]);
                }
                Collections.sort(entries);
                return entries;
            }
        };
        try {
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            mbeanServer.registerMBean(new StandardMBean(mbean, ManagedServiceContainer.class), OBJECT_NAME);
        }
        catch (Exception ex) {
            new StartException("Cannot register: " + OBJECT_NAME, (Throwable)ex);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            MBeanServer mbeanServer = (MBeanServer)this.injectedMBeanServer.getValue();
            mbeanServer.unregisterMBean(OBJECT_NAME);
        }
        catch (Exception ex) {
            this.log.errorf((Throwable)ex, "Cannot unregister: " + OBJECT_NAME, new Object[0]);
        }
    }

    public synchronized Void getValue() throws IllegalStateException {
        return null;
    }

    public static interface ManagedServiceContainer {
        public List<String> listServices();

        public List<String> listServicesByMode(String var1);

        public List<String> listServicesByState(String var1);

        public void setMode(String var1, String var2);
    }
}

