/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class DefaultDeploymentRegistryService
implements DeploymentRegistryService {
    private static final Logger log = Logger.getLogger(DefaultDeploymentRegistryService.class);
    private List<Deployment> deployments = new CopyOnWriteArrayList<Deployment>();

    public DefaultDeploymentRegistryService(BundleContext context) {
    }

    @Override
    public List<Deployment> getDeployments() {
        return Collections.unmodifiableList(this.deployments);
    }

    @Override
    public void registerDeployment(Deployment dep) {
        log.debugf("Register: %s", (Object)dep);
        this.deployments.add(dep);
    }

    @Override
    public void unregisterDeployment(Deployment dep) {
        log.debugf("Unregister: %s", (Object)dep);
        this.deployments.remove(dep);
    }

    @Override
    public Deployment getDeployment(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for null symbolic name");
        }
        Deployment dep = null;
        for (Deployment auxDep : this.deployments) {
            String auxName = auxDep.getSymbolicName();
            Version auxVersion = Version.parseVersion((String)auxDep.getVersion());
            if (!symbolicName.equals(auxName) || !version.equals((Object)auxVersion)) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }

    @Override
    public Deployment getDeployment(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Cannot obtain bundle deployment for: null");
        }
        Deployment dep = null;
        String urlLocation = url.toExternalForm();
        for (Deployment auxDep : this.deployments) {
            String auxLocation = auxDep.getLocation();
            if (!urlLocation.equals(auxLocation)) continue;
            dep = auxDep;
            break;
        }
        return dep;
    }
}

