/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class SystemDeployerService
implements DeployerService {
    private static final Logger log = Logger.getLogger(SystemDeployerService.class);
    private final BundleContext context;
    private final DeploymentRegistryService registry;
    private final StartLevel startLevel;

    public SystemDeployerService(BundleContext context, DeploymentRegistryService registry) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (registry == null) {
            throw new IllegalArgumentException("Null registry");
        }
        this.context = context;
        this.registry = registry;
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        this.startLevel = sref != null ? (StartLevel)context.getService(sref) : null;
    }

    @Override
    public Bundle deploy(Deployment dep) throws BundleException {
        Bundle bundle = this.deployInternal(dep);
        this.startInternal(dep);
        return bundle;
    }

    @Override
    public Bundle undeploy(Deployment dep) throws BundleException {
        return this.undeployInternal(dep);
    }

    @Override
    public void deploy(Deployment[] depArr) throws BundleException {
        for (Deployment dep : depArr) {
            this.deployInternal(dep);
        }
        for (Deployment dep : depArr) {
            this.startInternal(dep);
        }
    }

    @Override
    public void undeploy(Deployment[] depArr) throws BundleException {
        for (Deployment dep : depArr) {
            this.undeployInternal(dep);
        }
    }

    protected Bundle installBundle(Deployment dep) throws BundleException {
        return this.context.installBundle(dep.getLocation());
    }

    private Bundle deployInternal(Deployment dep) throws BundleException {
        log.debugf("Deploy: %s", (Object)dep);
        Bundle bundle = this.installBundle(dep);
        dep.addAttachment(Bundle.class, bundle);
        Integer level = dep.getStartLevel();
        if (this.startLevel != null && level != null && level > 0) {
            this.startLevel.setBundleStartLevel(bundle, level.intValue());
        }
        this.registry.registerDeployment(dep);
        return bundle;
    }

    private void startInternal(Deployment dep) throws BundleException {
        Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
        if (bundle != null && dep.isAutoStart()) {
            log.debugf("Start: %s", (Object)bundle);
            bundle.start();
        }
    }

    private Bundle undeployInternal(Deployment dep) {
        log.debugf("Undeploy: %s", (Object)dep);
        Bundle bundle = (Bundle)dep.getAttachment(Bundle.class);
        if (bundle == null) {
            log.warnf("Cannot obtain bundle for: %s", (Object)dep);
            return null;
        }
        try {
            this.registry.unregisterDeployment(dep);
            if (bundle.getState() != 1) {
                log.debugf("Uninstall: %s", (Object)bundle);
                bundle.uninstall();
            }
        }
        catch (Throwable ex) {
            log.warnf(ex, "Cannot uninstall: %s", (Object)dep);
        }
        return bundle;
    }
}

