/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class JavaContextService
implements Service<Context> {
    public static final ServiceName SERVICE_NAME = NamingService.SERVICE_NAME.append(new String[]{"context", "java"});
    private Context javaContext;

    public synchronized void start(StartContext context) throws StartException {
        InitialContext initContext;
        try {
            initContext = new InitialContext();
        }
        catch (NamingException e) {
            throw new StartException("Failed to get initial context", (Throwable)e);
        }
        try {
            this.javaContext = (Context)NamingUtils.cast(initContext.lookup("java:"));
        }
        catch (NamingException e) {
            throw new StartException("Failed to retrieve java: context", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.javaContext = null;
    }

    public synchronized Context getValue() throws IllegalStateException {
        if (this.javaContext == null) {
            throw new IllegalStateException("java: is null.  Has the service started");
        }
        return this.javaContext;
    }
}

