/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.osgi.vfs.VFSAdaptor;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs30.VirtualFileAdaptor30;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;

public class VFSAdaptor30
implements VFSAdaptor {
    private static Map<org.jboss.vfs.VirtualFile, VirtualFile> registry = new WeakHashMap<org.jboss.vfs.VirtualFile, VirtualFile>();
    private static Set<String> suffixes = new HashSet<String>();
    private static final TempFileProvider tmpProvider;

    static TempFileProvider getTempFileProvider() {
        return tmpProvider;
    }

    public VirtualFile toVirtualFile(URL url) throws IOException {
        try {
            org.jboss.vfs.VirtualFile vfsFile = VFS.getChild((URL)url);
            VirtualFileAdaptor30 absFile = (VirtualFileAdaptor30)this.adapt(vfsFile);
            return absFile;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public VirtualFile toVirtualFile(String name, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try {
            String internalName = name.replace('/', '-');
            if (File.separatorChar == '\\') {
                internalName = internalName.replace('\\', '-');
            }
            org.jboss.vfs.VirtualFile vfsFile = VFS.getChild((String)(internalName + "-" + System.currentTimeMillis()));
            Closeable mount = VFS.mountZip((InputStream)inputStream, (String)internalName, (org.jboss.vfs.VirtualFile)vfsFile, (TempFileProvider)tmpProvider);
            VirtualFileAdaptor30 absFile = new VirtualFileAdaptor30(vfsFile, mount);
            return absFile;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot mount input stream: " + name, ex);
        }
    }

    public VirtualFile adapt(Object other) {
        if (other == null) {
            return null;
        }
        if (!(other instanceof org.jboss.vfs.VirtualFile)) {
            throw new IllegalArgumentException("Not a org.jboss.vfs.VirtualFile: " + other);
        }
        org.jboss.vfs.VirtualFile vfsFile = (org.jboss.vfs.VirtualFile)other;
        VirtualFile absFile = registry.get(other);
        if (absFile != null) {
            return absFile;
        }
        absFile = new VirtualFileAdaptor30(vfsFile);
        if (this.acceptForMount(vfsFile)) {
            try {
                Closeable mount = VFS.mountZip((org.jboss.vfs.VirtualFile)vfsFile, (org.jboss.vfs.VirtualFile)vfsFile, (TempFileProvider)tmpProvider);
                absFile = new VirtualFileAdaptor30(vfsFile, mount);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot mount native file: " + other, ex);
            }
        }
        registry.put(vfsFile, absFile);
        return absFile;
    }

    private boolean acceptForMount(org.jboss.vfs.VirtualFile vfsFile) {
        boolean accept = false;
        if (vfsFile.isFile()) {
            String rootName = vfsFile.getName();
            for (String suffix : suffixes) {
                if (!rootName.endsWith(suffix)) continue;
                accept = true;
                break;
            }
        }
        return accept;
    }

    public Object adapt(VirtualFile absFile) {
        if (absFile == null) {
            return null;
        }
        VirtualFileAdaptor30 adaptor = (VirtualFileAdaptor30)absFile;
        return adaptor.getVirtualFile();
    }

    static void unregister(VirtualFileAdaptor30 absFile) {
        registry.remove(absFile.getVirtualFile());
    }

    static {
        suffixes.add(".jar");
        suffixes.add(".war");
        try {
            tmpProvider = TempFileProvider.create((String)"osgitmp-", null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create VFS temp file provider", ex);
        }
        Thread shutdownThread = new Thread("vfs-shutdown"){

            @Override
            public void run() {
                try {
                    tmpProvider.close();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot close VFS temp file provider", ex);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

