/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.MatchAllVirtualFileFilter;

class VFSFindEntriesEnumeration
implements Enumeration<URL> {
    private Iterator<URL> paths;

    public VFSFindEntriesEnumeration(VirtualFile root, VirtualFile file, String filePattern, boolean recurse) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        String rootPath = root.getPathName();
        VisitorAttributes attributes = new VisitorAttributes();
        attributes.setIncludeRoot(false);
        attributes.setLeavesOnly(true);
        if (recurse) {
            attributes.setRecurseFilter((VirtualFileFilter)MatchAllVirtualFileFilter.INSTANCE);
        }
        VisitorImpl visitor = new VisitorImpl(rootPath, filePattern, attributes);
        file.visit((VirtualFileVisitor)visitor);
        this.paths = visitor.paths.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.paths.hasNext();
    }

    @Override
    public URL nextElement() {
        return this.paths.next();
    }

    static class VisitorImpl
    implements VirtualFileVisitor {
        ArrayList<URL> paths = new ArrayList();
        Pattern filter;
        String rootPath;
        VisitorAttributes attributes;

        VisitorImpl(String rootPath, String filter, VisitorAttributes attributes) {
            this.rootPath = rootPath;
            this.filter = VisitorImpl.convertToPattern(filter);
            this.attributes = attributes;
        }

        public VisitorAttributes getAttributes() {
            return this.attributes;
        }

        public void visit(VirtualFile virtualFile) {
            Matcher matcher = this.filter.matcher(virtualFile.getName());
            if (!matcher.find()) {
                return;
            }
            try {
                this.paths.add(virtualFile.toURL());
            }
            catch (Exception e) {
                throw new RuntimeException("Error visiting " + virtualFile, e);
            }
        }

        private static Pattern convertToPattern(String filePattern) {
            filePattern = filePattern.replace("*", ".*");
            return Pattern.compile("^" + filePattern + "$");
        }
    }
}

