/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.osgi.vfs30.VFSAdaptor30;
import org.jboss.osgi.vfs30.VFSEntryPathsEnumeration;
import org.jboss.osgi.vfs30.VFSFindEntriesEnumeration;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualJarInputStream;

class VirtualFileAdaptor30
implements VirtualFile {
    private final org.jboss.vfs.VirtualFile vfsFile;
    private Closeable mount;
    private TempDir streamDir;
    private File streamFile;

    VirtualFileAdaptor30(org.jboss.vfs.VirtualFile vfsFile, Closeable mount) {
        this(vfsFile);
        this.mount = mount;
    }

    VirtualFileAdaptor30(org.jboss.vfs.VirtualFile vfsFile) {
        if (vfsFile == null) {
            throw new IllegalStateException("Null vfsFile");
        }
        this.vfsFile = vfsFile;
    }

    public org.jboss.vfs.VirtualFile getVirtualFile() {
        return this.vfsFile;
    }

    public String getName() {
        return this.vfsFile.getName();
    }

    public String getPathName() {
        return this.vfsFile.getPathName();
    }

    public boolean isFile() throws IOException {
        return this.vfsFile.isFile();
    }

    public boolean isDirectory() throws IOException {
        return this.vfsFile.isDirectory();
    }

    public URL toURL() throws IOException {
        URL url = this.vfsFile.toURL();
        return url;
    }

    public URL getStreamURL() throws IOException {
        if (this.vfsFile.isFile()) {
            return this.vfsFile.toURL();
        }
        if (this.streamFile == null) {
            this.streamDir = VFSAdaptor30.getTempFileProvider().createTempDir("urlstream");
            this.streamFile = this.streamDir.getFile(this.getName());
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.streamFile));
            VirtualJarInputStream jarIn = (VirtualJarInputStream)this.vfsFile.openStream();
            ZipEntry nextEntry = jarIn.getNextEntry();
            while (nextEntry != null) {
                jarOut.putNextEntry(nextEntry);
                VFSUtils.copyStream((InputStream)jarIn, (OutputStream)jarOut);
                nextEntry = jarIn.getNextEntry();
            }
            jarOut.close();
            jarIn.close();
        }
        return this.streamFile.toURI().toURL();
    }

    public VirtualFile getParent() {
        org.jboss.vfs.VirtualFile parent = this.vfsFile.getParent();
        return parent != null ? new VirtualFileAdaptor30(parent) : null;
    }

    public VirtualFile getChild(String path) throws IOException {
        org.jboss.vfs.VirtualFile child = this.vfsFile.getChild(path);
        if (!child.exists()) {
            return null;
        }
        return new VirtualFileAdaptor30(child);
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        ArrayList<VirtualFileAdaptor30> files = new ArrayList<VirtualFileAdaptor30>();
        for (org.jboss.vfs.VirtualFile child : this.vfsFile.getChildrenRecursively()) {
            files.add(new VirtualFileAdaptor30(child));
        }
        return Collections.unmodifiableList(files);
    }

    public List<VirtualFile> getChildren() throws IOException {
        ArrayList<VirtualFileAdaptor30> files = new ArrayList<VirtualFileAdaptor30>();
        for (org.jboss.vfs.VirtualFile child : this.vfsFile.getChildren()) {
            files.add(new VirtualFileAdaptor30(child));
        }
        return Collections.unmodifiableList(files);
    }

    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (pattern == null) {
            pattern = "*";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(child = this.vfsFile.getChild(path)).exists()) {
            return null;
        }
        return new VFSFindEntriesEnumeration(this.vfsFile, child, pattern, recurse);
    }

    public Enumeration<String> getEntryPaths(String path) throws IOException {
        org.jboss.vfs.VirtualFile child;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(child = path.length() > 0 ? this.vfsFile.getChild(path) : this.vfsFile).exists()) {
            return null;
        }
        return new VFSEntryPathsEnumeration(this.vfsFile, child);
    }

    public InputStream openStream() throws IOException {
        if (this.mount != null) {
            return this.getStreamURL().openStream();
        }
        return this.vfsFile.openStream();
    }

    public void recursiveCopy(File target) throws IOException {
        VFSUtils.recursiveCopy((org.jboss.vfs.VirtualFile)this.vfsFile, (File)target);
    }

    public void close() {
        VFSUtils.safeClose((Closeable)this.mount);
        VFSAdaptor30.unregister(this);
        if (this.streamFile != null) {
            File streamParent = this.streamFile.getParentFile();
            this.streamFile.delete();
            streamParent.delete();
            this.streamFile = null;
        }
    }

    public boolean equals(Object obj) {
        return this.vfsFile.equals(obj);
    }

    public int hashCode() {
        return this.vfsFile.hashCode();
    }

    public String toString() {
        return this.vfsFile.toString();
    }
}

