/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.InjectorLogger;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class MethodInjector<T>
implements Injector<T> {
    private final Value<Method> methodValue;
    private final Value<?> injectedValue;
    private final Value<?> targetValue;
    private final List<? extends Value<?>> parameterList;

    public MethodInjector(Value<Method> methodValue, Value<?> targetValue, Value<?> injectedValue, List<? extends Value<?>> parameterList) {
        this.methodValue = methodValue;
        this.targetValue = targetValue;
        this.injectedValue = injectedValue;
        this.parameterList = parameterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(T value) throws InjectionException {
        ThreadLocalValue<Object> tlsTargetValue = Values.injectedValue();
        ThreadLocalValue<Object> tlsThisValue = Values.thisValue();
        Value<?> thisValue = this.targetValue;
        Value<Object> oldTarget = tlsTargetValue.getAndSetValue(new ImmediateValue<T>(value));
        try {
            Value<Object> oldThis = tlsThisValue.getAndSetValue(thisValue);
            try {
                this.methodValue.getValue().invoke(thisValue.getValue(), Values.getValues(this.parameterList));
            }
            catch (Exception e) {
                throw new InjectionException("Injection failed", e);
            }
            finally {
                tlsThisValue.setValue(oldThis);
            }
        }
        finally {
            tlsTargetValue.setValue(oldTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninject() {
        ThreadLocalValue<Object> injectedValue = Values.injectedValue();
        ThreadLocalValue<Object> thisValue = Values.thisValue();
        Value<Object> oldTarget = injectedValue.getAndSetValue(this.injectedValue);
        try {
            Value<Object> oldThis = thisValue.getAndSetValue(this.targetValue);
            try {
                this.methodValue.getValue().invoke(this.targetValue.getValue(), Values.getValues(this.parameterList));
                thisValue.setValue(oldThis);
            }
            catch (Throwable t) {
                try {
                    InjectorLogger.INSTANCE.uninjectFailed(t, this.methodValue);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    thisValue.setValue(oldThis);
                }
            }
        }
        finally {
            injectedValue.setValue(oldTarget);
        }
    }
}

