/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

abstract class AbstractBatchBuilder
implements BatchBuilder {
    private final Set<ServiceListener<Object>> listeners = new HashSet<ServiceListener<Object>>();
    private final Set<ServiceName> dependencies = new HashSet<ServiceName>();

    AbstractBatchBuilder() {
    }

    abstract boolean isDone();

    @Override
    public BatchBuilder addListener(ServiceListener<Object> listener) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        this.listeners.add(listener);
        return this;
    }

    @Override
    public BatchBuilder addListener(ServiceListener<Object> ... listeners) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        Set<ServiceListener<Object>> batchListeners = this.listeners;
        for (ServiceListener<Object> listener : listeners) {
            batchListeners.add(listener);
        }
        return this;
    }

    @Override
    public BatchBuilder addListener(Collection<ServiceListener<Object>> listeners) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        if (listeners == null) {
            throw new IllegalArgumentException("Listeners can not be null");
        }
        Set<ServiceListener<Object>> batchListeners = this.listeners;
        for (ServiceListener<Object> listener : listeners) {
            batchListeners.add(listener);
        }
        return this;
    }

    @Override
    public BatchBuilder addDependency(ServiceName dependency) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        this.dependencies.add(dependency);
        return this;
    }

    @Override
    public BatchBuilder addDependency(ServiceName ... dependencies) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        Set<ServiceName> batchDependencies = this.dependencies;
        for (ServiceName dependency : dependencies) {
            batchDependencies.add(dependency);
        }
        return this;
    }

    @Override
    public BatchBuilder addDependency(Collection<ServiceName> dependencies) {
        if (this.isDone()) {
            throw AbstractBatchBuilder.alreadyInstalled();
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Dependencies can not be null");
        }
        Set<ServiceName> batchDependencies = this.dependencies;
        for (ServiceName dependency : dependencies) {
            batchDependencies.add(dependency);
        }
        return this;
    }

    static IllegalStateException alreadyInstalled() {
        return new IllegalStateException("Batch already installed");
    }

    Set<ServiceListener<Object>> getListeners() {
        return this.listeners;
    }

    Set<ServiceName> getDependencies() {
        return this.dependencies;
    }
}

