/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public final class ServiceName
implements Comparable<ServiceName>,
Serializable {
    private static final long serialVersionUID = 2336190201880964151L;
    private final String name;
    private final ServiceName parent;
    private final transient int hashCode;
    public static final ServiceName JBOSS = new ServiceName(null, "jboss");
    private static final Field hashCodeField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = ServiceName.class.getDeclaredField("hashCode");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            field.setAccessible(true);
            return field;
        }
    });

    public static ServiceName of(String ... parts) {
        return ServiceName.of(null, parts);
    }

    public static ServiceName of(ServiceName parent, String ... parts) {
        if (parts.length < 1) {
            throw new IllegalArgumentException("Must provide at least one name segment");
        }
        ServiceName current = parent;
        for (String part : parts) {
            if (part.isEmpty()) {
                throw new IllegalArgumentException("Empty name segment is not allowed");
            }
            current = new ServiceName(current, part);
        }
        return current;
    }

    private ServiceName(ServiceName parent, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.parent = parent;
        this.hashCode = ServiceName.calculateHashCode(parent, name);
    }

    private static int calculateHashCode(ServiceName parent, String name) {
        int result = parent == null ? 1 : parent.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }

    public ServiceName append(String ... parts) {
        return ServiceName.of(this, parts);
    }

    public ServiceName append(ServiceName serviceName) {
        if (serviceName.parent == null) {
            return this.append(serviceName.name);
        }
        return this.append(serviceName.parent).append(serviceName.name);
    }

    public int length() {
        ServiceName parent = this.parent;
        return parent == null ? 1 : 1 + parent.length();
    }

    public ServiceName getParent() {
        return this.parent;
    }

    public String getSimpleName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ServiceName && this.equals((ServiceName)o);
    }

    public boolean equals(ServiceName o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.hashCode != o.hashCode || !this.name.equals(o.name)) {
            return false;
        }
        ServiceName parent = this.parent;
        ServiceName oparent = o.parent;
        return parent != null && parent.equals(oparent) || oparent == null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "service " + this.getCanonicalName();
    }

    public String getCanonicalName() {
        return this.getCanonicalName(new StringBuilder()).toString();
    }

    public static ServiceName parse(String original) throws IllegalArgumentException {
        int charSize;
        int originalLength = original.length();
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int state = 0;
        char escapedChar = '\u0000';
        block36: for (int i = 0; i < originalLength; i += charSize) {
            int nextOffset = original.offsetByCodePoints(i, 1);
            charSize = nextOffset - i;
            int c = original.codePointAt(i);
            if (!Character.isValidCodePoint(c)) {
                throw ServiceName.invalidCodePoint(i);
            }
            if (Character.isISOControl(c)) {
                throw ServiceName.invalidNameCharacter(i);
            }
            switch (state) {
                case 0: {
                    builder.setLength(0);
                    if (c == 34) {
                        state = 2;
                        continue block36;
                    }
                    if (c == 46 || c == 92 || Character.isWhitespace(c)) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    builder.append(original.substring(i, nextOffset));
                    state = 1;
                    continue block36;
                }
                case 1: {
                    if (c == 92 || c == 34 || Character.isWhitespace(c)) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    if (c == 46) {
                        segments.add(builder.toString());
                        state = 0;
                        continue block36;
                    }
                    builder.append(original.substring(i, nextOffset));
                    continue block36;
                }
                case 2: {
                    if (c == 34) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    if (c == 92) {
                        state = 3;
                        continue block36;
                    }
                    builder.append(original.substring(i, nextOffset));
                    state = 4;
                    continue block36;
                }
                case 3: {
                    switch (c) {
                        case 34: {
                            builder.append('\"');
                            state = 4;
                            continue block36;
                        }
                        case 39: {
                            builder.append('\'');
                            state = 4;
                            continue block36;
                        }
                        case 92: {
                            builder.append('\\');
                            state = 4;
                            continue block36;
                        }
                        case 117: {
                            state = 5;
                            continue block36;
                        }
                        case 98: {
                            builder.append('\b');
                            state = 4;
                            continue block36;
                        }
                        case 116: {
                            builder.append('\t');
                            state = 4;
                            continue block36;
                        }
                        case 110: {
                            builder.append('\n');
                            state = 4;
                            continue block36;
                        }
                        case 102: {
                            builder.append('\f');
                            state = 4;
                            continue block36;
                        }
                        case 114: {
                            builder.append('\r');
                            state = 4;
                            continue block36;
                        }
                        case 48: {
                            builder.append('\u0000');
                            state = 4;
                            continue block36;
                        }
                    }
                    throw ServiceName.invalidNameCharacter(i);
                }
                case 4: {
                    if (c == 34) {
                        segments.add(builder.toString());
                        state = 9;
                        continue block36;
                    }
                    if (c == 92) {
                        state = 3;
                        continue block36;
                    }
                    builder.append(original.substring(i, nextOffset));
                    continue block36;
                }
                case 5: {
                    int v;
                    try {
                        v = Integer.parseInt(original.substring(i, nextOffset), 16);
                    }
                    catch (NumberFormatException e) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    escapedChar = (char)(v << 12);
                    state = 6;
                    continue block36;
                }
                case 6: {
                    int v;
                    try {
                        v = Integer.parseInt(original.substring(i, nextOffset), 16);
                    }
                    catch (NumberFormatException e) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    escapedChar = (char)(escapedChar | (char)(v << 8));
                    state = 7;
                    continue block36;
                }
                case 7: {
                    int v;
                    try {
                        v = Integer.parseInt(original.substring(i, nextOffset), 16);
                    }
                    catch (NumberFormatException e) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    escapedChar = (char)(escapedChar | (char)(v << 4));
                    state = 8;
                    continue block36;
                }
                case 8: {
                    int v;
                    try {
                        v = Integer.parseInt(original.substring(i, nextOffset), 16);
                    }
                    catch (NumberFormatException e) {
                        throw ServiceName.invalidNameCharacter(i);
                    }
                    escapedChar = (char)(escapedChar | (char)v);
                    builder.append(escapedChar);
                    state = 4;
                    continue block36;
                }
                case 9: {
                    if (c == 46) {
                        state = 0;
                        continue block36;
                    }
                    throw ServiceName.invalidNameCharacter(i);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (state) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw ServiceName.unexpectedEnd();
            }
            case 1: 
            case 9: {
                segments.add(builder.toString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return ServiceName.of(segments.toArray(new String[segments.size()]));
    }

    private static IllegalArgumentException unexpectedEnd() {
        return new IllegalArgumentException("Unexpected end of name");
    }

    private static IllegalArgumentException invalidCodePoint(int i) {
        return new IllegalArgumentException("Invalid code point at offset " + i);
    }

    private static IllegalArgumentException invalidNameCharacter(int i) {
        return new IllegalArgumentException("Invalid name character at offset " + i);
    }

    private StringBuilder getCanonicalName(StringBuilder target) {
        ServiceName parent = this.parent;
        if (parent != null) {
            parent.getCanonicalName(target);
            target.append('.');
        }
        String name = this.name;
        int nameLength = name.length();
        boolean simple = true;
        for (int i = 0; i < nameLength; i += name.offsetByCodePoints(i, 1)) {
            int c = name.codePointAt(i);
            if (!Character.isISOControl(c) && !Character.isWhitespace(c) && c != 46 && c != 34) continue;
            simple = false;
            break;
        }
        if (simple) {
            target.append(name);
        } else {
            int charSize;
            target.append('\"');
            block11: for (int i = 0; i < nameLength; i += charSize) {
                int nextOffset = name.offsetByCodePoints(i, 1);
                charSize = nextOffset - i;
                int c = name.codePointAt(i);
                switch (c) {
                    case 8: {
                        target.append('\\').append('b');
                        continue block11;
                    }
                    case 9: {
                        target.append('\\').append('t');
                        continue block11;
                    }
                    case 10: {
                        target.append('\\').append('n');
                        continue block11;
                    }
                    case 12: {
                        target.append('\\').append('f');
                        continue block11;
                    }
                    case 13: {
                        target.append('\\').append('r');
                        continue block11;
                    }
                    case 0: {
                        target.append('\\').append('0');
                        continue block11;
                    }
                    case 34: {
                        target.append('\\').append('\"');
                        continue block11;
                    }
                    case 92: {
                        target.append('\\').append('\\');
                        continue block11;
                    }
                    default: {
                        if (Character.isISOControl(c)) {
                            String hs = Integer.toHexString(c);
                            target.append("\\u");
                            for (int j = hs.length(); j < 4; ++j) {
                                target.append('0');
                            }
                            target.append(hs);
                            continue block11;
                        }
                        target.append(name.substring(i, nextOffset));
                    }
                }
            }
            target.append('\"');
        }
        return target;
    }

    @Override
    public int compareTo(ServiceName o) {
        int length2;
        if (o == null) {
            throw new IllegalArgumentException("o is null");
        }
        if (this == o) {
            return 0;
        }
        int length1 = this.length();
        if (length1 == (length2 = o.length())) {
            return this.compareTo(o, length1 - 1);
        }
        int diff = length1 - length2;
        if (diff > 0) {
            ServiceName x = this;
            while (diff > 0) {
                x = x.parent;
                --diff;
            }
            int res = x.compareTo(o, length2 - 1);
            return res == 0 ? 1 : res;
        }
        return -o.compareTo(this);
    }

    private int compareTo(ServiceName o, int remainingLength) {
        if (this == o) {
            return 0;
        }
        if (remainingLength == 0) {
            return this.name.compareTo(o.name);
        }
        int res = this.parent.compareTo(o.parent, remainingLength - 1);
        return res == 0 ? this.name.compareTo(o.name) : res;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashCodeField.setInt(this, ServiceName.calculateHashCode(this.parent, this.name));
        }
        catch (IllegalAccessException e) {
            InvalidObjectException e2 = new InvalidObjectException("Cannot set hash code field");
            e2.initCause(e);
            throw e2;
        }
    }
}

