/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.AbstractBatchBuilder;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.value.Value;

final class SubBatchBuilderImpl
extends AbstractBatchBuilder {
    private final BatchBuilderImpl parentBatch;
    private final Set<BatchServiceBuilder<?>> subBatchServiceBuilders = new HashSet();

    SubBatchBuilderImpl(BatchBuilderImpl parentBatch) {
        this.parentBatch = parentBatch;
    }

    @Override
    public <T> BatchServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        if (this.isDone()) {
            throw SubBatchBuilderImpl.alreadyInstalled();
        }
        BatchServiceBuilder batchServiceBuilder = this.parentBatch.addServiceValue(name, (Value)value);
        this.subBatchServiceBuilders.add(batchServiceBuilder);
        return batchServiceBuilder;
    }

    @Override
    public <T> BatchServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        if (this.isDone()) {
            throw SubBatchBuilderImpl.alreadyInstalled();
        }
        BatchServiceBuilder batchServiceBuilder = this.parentBatch.addService(name, (Service)service);
        this.subBatchServiceBuilders.add(batchServiceBuilder);
        return batchServiceBuilder;
    }

    @Override
    public <T> BatchServiceBuilder<T> addServiceValueIfNotExist(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        if (this.isDone()) {
            throw SubBatchBuilderImpl.alreadyInstalled();
        }
        BatchServiceBuilder batchServiceBuilder = this.parentBatch.addServiceValueIfNotExist(name, value);
        this.subBatchServiceBuilders.add(batchServiceBuilder);
        return batchServiceBuilder;
    }

    void reconcile() {
        Set<ServiceListener<Object>> listeners = this.getListeners();
        Set<ServiceName> dependencies = this.getDependencies();
        Set<BatchServiceBuilder<?>> subBatchServiceBuilders = this.subBatchServiceBuilders;
        for (BatchServiceBuilder<?> batchServiceBuilder : subBatchServiceBuilders) {
            batchServiceBuilder.addListener(listeners);
            batchServiceBuilder.addDependencies(dependencies);
        }
    }

    @Override
    boolean isDone() {
        return this.parentBatch.isDone();
    }

    @Override
    public void install() throws ServiceRegistryException {
        throw new UnsupportedOperationException("Sub-batches do not support the install operation.");
    }

    @Override
    public BatchBuilder subBatchBuilder() {
        throw new UnsupportedOperationException("Sub-batches do not support creating nested sub-batches.");
    }
}

