/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.translate;

import org.jboss.msc.translate.TranslationException;
import org.jboss.msc.translate.Translator;

public final class CastingTranslator<I, O>
implements Translator<I, O> {
    private final Class<O> type;

    public CastingTranslator(Class<O> type) {
        this.type = type;
    }

    @Override
    public O translate(I input) throws TranslationException {
        try {
            return this.type.cast(input);
        }
        catch (ClassCastException e) {
            throw new TranslationException("Input is not of the correct type (expected " + this.type + ", got " + input.getClass() + ")");
        }
    }
}

