/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class ConstructedValue<T>
implements Value<T> {
    private final Value<Constructor<T>> constructorValue;
    private final List<? extends Value<?>> parameters;

    public ConstructedValue(Value<Constructor<T>> constructorValue, List<? extends Value<?>> parameters) {
        this.constructorValue = constructorValue;
        this.parameters = parameters;
    }

    @Override
    public T getValue() throws IllegalStateException {
        try {
            return this.constructorValue.getValue().newInstance(Values.getValues(this.parameters));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Field is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke constructor", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to construct instance", e);
        }
    }
}

