/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import org.jboss.msc.value.Value;

public final class LookupClassValue
implements Value<Class<?>> {
    private final String className;
    private final Value<? extends ClassLoader> classLoaderValue;
    private volatile Class<?> result;

    public LookupClassValue(String className, Value<? extends ClassLoader> classLoaderValue) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (classLoaderValue == null) {
            throw new IllegalArgumentException("classLoaderValue is null");
        }
        this.className = className;
        this.classLoaderValue = classLoaderValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getValue() throws IllegalStateException {
        Class<?> result = this.result;
        if (result != null) {
            return result;
        }
        LookupClassValue lookupClassValue = this;
        synchronized (lookupClassValue) {
            result = this.result;
            if (result != null) {
                return result;
            }
            ClassLoader classLoader = this.classLoaderValue.getValue();
            try {
                this.result = result = Class.forName(this.className, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class available with name '" + this.className + "'");
            }
            return result;
        }
    }
}

