/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.postoffice.Address;
import org.hornetq.core.postoffice.impl.WildcardAddressManager;

public class AddressImpl
implements Address {
    private SimpleString address;
    private SimpleString[] addressParts;
    private boolean containsWildCard;
    private final List<Address> linkedAddresses = new ArrayList<Address>();

    public AddressImpl(SimpleString address) {
        this.address = address;
        this.addressParts = address.split('.');
        this.containsWildCard = address.contains('*') || address.contains('#');
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString[] getAddressParts() {
        return this.addressParts;
    }

    @Override
    public boolean containsWildCard() {
        return this.containsWildCard;
    }

    @Override
    public List<Address> getLinkedAddresses() {
        return this.linkedAddresses;
    }

    @Override
    public void addLinkedAddress(Address address) {
        if (!this.linkedAddresses.contains(address)) {
            this.linkedAddresses.add(address);
        }
    }

    @Override
    public void removeLinkedAddress(Address actualAddress) {
        this.linkedAddresses.remove(actualAddress);
    }

    @Override
    public void removeAddressPart(int pos) {
        SimpleString newAddress = new SimpleString("");
        boolean started = false;
        for (int i = 0; i < this.addressParts.length; ++i) {
            SimpleString addressPart = this.addressParts[i];
            if (i == pos) continue;
            if (started) {
                newAddress = newAddress.concat('.');
            }
            newAddress = newAddress.concat(addressPart);
            started = true;
        }
        this.address = newAddress;
        this.addressParts = this.address.split('.');
        this.containsWildCard = this.address.contains('*');
    }

    @Override
    public boolean matches(Address add) {
        if (this.containsWildCard == add.containsWildCard()) {
            return this.address.equals(add.getAddress());
        }
        int pos = 0;
        int matchPos = 0;
        while (matchPos < add.getAddressParts().length) {
            if (pos >= this.addressParts.length) {
                return pos + 1 == add.getAddressParts().length && add.getAddressParts()[pos].equals(WildcardAddressManager.ANY_WORDS_SIMPLESTRING);
            }
            SimpleString curr = this.addressParts[pos];
            SimpleString next = this.addressParts.length > pos + 1 ? this.addressParts[pos + 1] : null;
            SimpleString currMatch = add.getAddressParts()[matchPos];
            if (currMatch.equals(WildcardAddressManager.SINGLE_WORD_SIMPLESTRING)) {
                ++pos;
                ++matchPos;
                continue;
            }
            if (currMatch.equals(WildcardAddressManager.ANY_WORDS_SIMPLESTRING)) {
                if (matchPos == this.addressParts.length - 1) {
                    ++pos;
                    ++matchPos;
                    continue;
                }
                if (next == null) {
                    return false;
                }
                if (matchPos == add.getAddressParts().length - 1) {
                    return true;
                }
                SimpleString nextToMatch = add.getAddressParts()[matchPos + 1];
                while (curr != null && !curr.equals(nextToMatch)) {
                    curr = next;
                    next = this.addressParts.length > ++pos + 1 ? this.addressParts[pos + 1] : null;
                }
                if (curr == null) {
                    return false;
                }
                ++matchPos;
                continue;
            }
            if (!curr.equals(currMatch)) {
                return false;
            }
            ++pos;
            ++matchPos;
        }
        return pos == this.addressParts.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressImpl address1 = (AddressImpl)o;
        return this.address.equals(address1.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

