/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.StandaloneServer;
import org.jboss.as.server.SystemExiter;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    Properties props = new Properties(System.getProperties());

    public static void main(String[] args) {
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        System.setProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        Main.create(args);
    }

    private static StandaloneServer create(String[] args) {
        Main main = new Main();
        return main.boot(args);
    }

    private Main() {
    }

    private StandaloneServer boot(String[] args) {
        StandaloneServer server = null;
        try {
            ServerEnvironment config = Main.determineEnvironment(args, this.props);
            if (config != null) {
                if (!config.isStandalone()) {
                    throw new IllegalStateException();
                }
                server = new StandaloneServer(config);
                server.start();
                return server;
            }
            this.abort(null);
        }
        catch (Throwable t) {
            this.abort(t);
        }
        return null;
    }

    private void abort(Throwable t) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        try {
            throw new UnsupportedOperationException("implement me");
        }
        catch (Throwable throwable) {
            SystemExiter.exit(1);
            throw throwable;
        }
    }

    public static ServerEnvironment determineEnvironment(String[] args, Properties systemProperties) {
        String procName = null;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if ("-properties".equals(arg) || "-P".equals(arg)) {
                    URL url = null;
                    try {
                        url = Main.makeURL(args[++i]);
                        Properties props = System.getProperties();
                        props.load(url.openConnection().getInputStream());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        System.err.printf("Malformed URL provided for option %s\n", arg);
                        return null;
                    }
                    catch (IOException e) {
                        System.err.printf("Unable to load properties from URL %s\n", url);
                        return null;
                    }
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    continue;
                }
                System.err.printf("Invalid option '%s'\n", arg);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                return null;
            }
        }
        return new ServerEnvironment(systemProperties, procName, true);
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

