/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.model.UpdateResultHandlerResponse;
import org.jboss.as.protocol.mgmt.ManagementException;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.as.server.mgmt.ServerUpdateController;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class ServerControllerImpl
implements ServerController,
Service<ServerController> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private final InjectedValue<ServerConfigurationPersister> configurationPersisterValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorValue = new InjectedValue();
    private final ServiceContainer container;
    private final ServerModel serverModel;
    private final boolean standalone;
    private ServerConfigurationPersister configurationPersister;
    private ExecutorService executor;

    ServerControllerImpl(ServerModel model, ServiceContainer container, boolean standalone) {
        this.serverModel = model;
        this.container = container;
        this.standalone = standalone;
    }

    @Override
    public ServerModel getServerModel() {
        return this.serverModel;
    }

    @Override
    public List<UpdateResultHandlerResponse<?>> applyUpdates(List<AbstractServerModelUpdate<?>> updates, boolean rollbackOnFailure, boolean modelOnly) {
        int count = updates.size();
        log.debugf("Received %s updates", (Object)count);
        ArrayList results = new ArrayList(count);
        if (modelOnly && !this.standalone) {
            IllegalStateException e = new IllegalStateException("Update sets that only affect the configuration and not the runtime are not valid on a domain-based server");
            for (int i = 0; i < count; ++i) {
                results.add(UpdateResultHandlerResponse.createFailureResponse((Throwable)e));
            }
            return results;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ServerUpdateCommitHandlerImpl handler = new ServerUpdateCommitHandlerImpl(results, count, latch);
        ServerUpdateController controller = new ServerUpdateController(this.getServerModel(), this.container, this.executor, handler, rollbackOnFailure, !modelOnly);
        for (int i = 0; i < count; ++i) {
            controller.addServerModelUpdate(updates.get(i), handler, i);
        }
        controller.executeUpdates();
        log.debugf("Executed %s updates", (Object)updates.size());
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ManagementException("failed to execute updates", (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, P> void update(AbstractServerModelUpdate<R> update, UpdateResultHandler<R, P> resultHandler, P param) {
        UpdateContextImpl updateContext = new UpdateContextImpl(this.container.batchBuilder(), this.container);
        ServerModel serverModel = this.serverModel;
        synchronized (serverModel) {
            try {
                this.serverModel.update(update);
            }
            catch (UpdateFailedException e) {
                resultHandler.handleFailure((Throwable)e, param);
                return;
            }
        }
        update.applyUpdate((UpdateContext)updateContext, resultHandler, param);
    }

    @Override
    public void shutdown() {
        this.container.shutdown();
    }

    public InjectedValue<ServerConfigurationPersister> getConfigurationPersisterValue() {
        return this.configurationPersisterValue;
    }

    public InjectedValue<ExecutorService> getExecutorValue() {
        return this.executorValue;
    }

    public ServerController getValue() throws IllegalStateException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.configurationPersister = (ServerConfigurationPersister)this.configurationPersisterValue.getValue();
            this.executor = (ExecutorService)this.executorValue.getValue();
        }
        catch (IllegalStateException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
    }

    private class ServerUpdateCommitHandlerImpl
    implements ServerUpdateController.ServerUpdateCommitHandler,
    UpdateResultHandler<Object, Integer> {
        private final int count;
        private final Map<Integer, UpdateResultHandlerResponse<?>> map = new ConcurrentHashMap();
        private final List<UpdateResultHandlerResponse<?>> responses;
        private final CountDownLatch latch;

        public ServerUpdateCommitHandlerImpl(List<UpdateResultHandlerResponse<?>> responses, int count, CountDownLatch latch) {
            this.responses = responses;
            this.count = count;
            this.latch = latch;
        }

        @Override
        public void handleUpdateCommit(ServerUpdateController controller, ServerUpdateController.Status priorStatus) {
            log.tracef("Committed with prior status %s", (Object)priorStatus);
            ServerControllerImpl.this.configurationPersister.configurationModified();
            for (int i = 0; i < this.count; ++i) {
                this.responses.add(this.map.get(i));
            }
            this.latch.countDown();
        }

        public void handleCancellation(Integer param) {
            log.tracef("Update %s cancelled", (Object)param);
            this.map.put(param, UpdateResultHandlerResponse.createCancellationResponse());
        }

        public void handleFailure(Throwable cause, Integer param) {
            log.tracef("Update %s failed with %s", (Object)param, (Object)cause);
            this.map.put(param, UpdateResultHandlerResponse.createFailureResponse((Throwable)cause));
        }

        public void handleRollbackCancellation(Integer param) {
            log.tracef("Update %s rollback cancelled", (Object)param);
            UpdateResultHandlerResponse<?> rsp = this.map.get(param);
            if (rsp == null) {
                log.warn((Object)("No response associated with index " + param));
                return;
            }
            this.map.put(param, UpdateResultHandlerResponse.createRollbackCancelledResponse(rsp));
        }

        public void handleRollbackFailure(Throwable cause, Integer param) {
            log.tracef("Update %s rollback failed with %s", (Object)param, (Object)cause);
            UpdateResultHandlerResponse<?> rsp = this.map.get(param);
            if (rsp == null) {
                log.warn((Object)("No response associated with index " + param));
                return;
            }
            this.map.put(param, UpdateResultHandlerResponse.createRollbackFailedResponse(rsp, (Throwable)cause));
        }

        public void handleRollbackSuccess(Integer param) {
            log.tracef("Update %s rolled back", (Object)param);
            UpdateResultHandlerResponse<?> rsp = this.map.get(param);
            if (rsp == null) {
                log.warn((Object)("No response associated with index " + param));
                return;
            }
            this.map.put(param, UpdateResultHandlerResponse.createRollbackResponse(rsp));
        }

        public void handleRollbackTimeout(Integer param) {
            log.tracef("Update %s rollback timed out", (Object)param);
            UpdateResultHandlerResponse<?> rsp = this.map.get(param);
            if (rsp == null) {
                log.warn((Object)("No response associated with index " + param));
                return;
            }
            this.map.put(param, UpdateResultHandlerResponse.createRollbackTimedOutResponse(rsp));
        }

        public void handleSuccess(Object result, Integer param) {
            log.tracef("Update %s succeeded", (Object)param);
            this.map.put(param, UpdateResultHandlerResponse.createSuccessResponse((Object)result));
        }

        public void handleTimeout(Integer param) {
            log.tracef("Update %s timed out", (Object)param);
            this.responses.set(param, UpdateResultHandlerResponse.createTimeoutResponse());
        }
    }

    final class UpdateContextImpl
    implements UpdateContext {
        private final BatchBuilder batchBuilder;
        private final ServiceContainer serviceContainer;

        UpdateContextImpl(BatchBuilder batchBuilder, ServiceContainer serviceContainer) {
            this.batchBuilder = batchBuilder;
            this.serviceContainer = serviceContainer;
        }

        public BatchBuilder getBatchBuilder() {
            return this.batchBuilder;
        }

        public ServiceContainer getServiceContainer() {
            return this.serviceContainer;
        }
    }
}

