/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.services.path.AbsolutePathService;
import org.jboss.msc.service.BatchBuilder;

class ServerEnvironmentServices {
    private static final String USER_DIR = "user.dir";
    private static final String USER_HOME = "user.home";
    private static final String JAVA_HOME = "java.home";

    ServerEnvironmentServices() {
    }

    static void addServices(ServerEnvironment environment, BatchBuilder batch) {
        ServerEnvironmentServices.addEnvironmentService(environment, batch);
        ServerEnvironmentServices.addPathService("jboss.home.dir", environment.getHomeDir(), batch);
        ServerEnvironmentServices.addPathService("jboss.server.base.dir", environment.getServerBaseDir(), batch);
        ServerEnvironmentServices.addPathService("jboss.server.config.dir", environment.getServerConfigurationDir(), batch);
        ServerEnvironmentServices.addPathService("jboss.server.data.dir", environment.getServerDataDir(), batch);
        ServerEnvironmentServices.addPathService("jboss.server.log.dir", environment.getServerLogDir(), batch);
        ServerEnvironmentServices.addPathService("jboss.server.temp.dir", environment.getServerTempDir(), batch);
        ServerEnvironmentServices.addPathService(USER_DIR, ServerEnvironmentServices.getProperty(USER_DIR), batch);
        ServerEnvironmentServices.addPathService(USER_HOME, ServerEnvironmentServices.getProperty(USER_HOME), batch);
        ServerEnvironmentServices.addPathService(JAVA_HOME, ServerEnvironmentServices.getProperty(JAVA_HOME), batch);
    }

    static void addEnvironmentService(ServerEnvironment environment, BatchBuilder batch) {
        ServerEnvironmentService.addService(environment, batch);
    }

    static void addPathService(String name, File file, BatchBuilder batch) {
        ServerEnvironmentServices.addPathService(name, file.getAbsolutePath(), batch);
    }

    static void addPathService(String name, String path, BatchBuilder batch) {
        AbsolutePathService.addService((String)name, (String)path, (BatchBuilder)batch);
    }

    static String getProperty(String propertyName) {
        return System.getProperty(propertyName);
    }
}

