/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.SocketFactory;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerManagerConnectionService
implements Service<Connection> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "manager", "connection"});
    private final InjectedValue<InetSocketAddress> smAddress = new InjectedValue();
    private Connection connection;

    public synchronized void start(StartContext context) throws StartException {
        ProtocolClient.Configuration configuration = new ProtocolClient.Configuration();
        configuration.setServerAddress((InetSocketAddress)this.smAddress.getValue());
        configuration.setMessageHandler(MessageHandler.NULL);
        configuration.setSocketFactory(SocketFactory.getDefault());
        configuration.setThreadFactory(Executors.defaultThreadFactory());
        configuration.setReadExecutor((Executor)Executors.newCachedThreadPool());
        ProtocolClient protocolClient = new ProtocolClient(configuration);
        try {
            this.connection = protocolClient.connect();
        }
        catch (IOException e) {
            throw new StartException("Failed to start remote Server Manager connection", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        StreamUtils.safeClose((Closeable)this.connection);
        this.connection = null;
    }

    public synchronized Connection getValue() throws IllegalStateException {
        return this.connection;
    }

    public Injector<InetSocketAddress> getSmAddressInjector() {
        return this.smAddress;
    }
}

