/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.deployment.chain.JarDeploymentActivator;
import org.jboss.as.deployment.module.ClassifyingModuleLoaderInjector;
import org.jboss.as.deployment.module.ClassifyingModuleLoaderService;
import org.jboss.as.deployment.module.DeploymentModuleLoader;
import org.jboss.as.deployment.module.DeploymentModuleLoaderImpl;
import org.jboss.as.deployment.module.DeploymentModuleLoaderService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.ServerControllerImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentServices;
import org.jboss.as.server.ServerModelService;
import org.jboss.as.server.ServerStartBatchBuilder;
import org.jboss.as.server.ServerStartupListener;
import org.jboss.as.server.ServerTask;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.as.server.mgmt.ServerConfigurationPersisterImpl;
import org.jboss.as.server.mgmt.ShutdownHandlerImpl;
import org.jboss.as.server.mgmt.deployment.ServerDeploymentManagerImpl;
import org.jboss.as.server.mgmt.deployment.ServerDeploymentRepositoryImpl;
import org.jboss.as.server.standalone.deployment.DeploymentScannerFactoryService;
import org.jboss.as.server.standalone.management.StandaloneServerManagementServices;
import org.jboss.as.services.net.SocketBindingManager;
import org.jboss.as.services.net.SocketBindingManagerService;
import org.jboss.as.version.Version;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.Value;

public final class ServerStartTask
implements ServerTask,
Serializable,
ObjectInputValidation {
    public static final ServiceName AS_SERVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "server"});
    private static final long serialVersionUID = -8505496119636153918L;
    private final String serverName;
    private final int portOffset;
    private final List<ServiceActivator> startServices;
    private final List<AbstractServerModelUpdate<?>> updates;
    private final ServerEnvironment providedEnvironment;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");

    public ServerStartTask(String serverName, int portOffset, List<ServiceActivator> startServices, List<AbstractServerModelUpdate<?>> updates) {
        this(serverName, portOffset, startServices, updates, null);
        if (serverName == null || serverName.length() == 0) {
            throw new IllegalArgumentException("Server name " + serverName + " is invalid; cannot be null or blank");
        }
    }

    public ServerStartTask(int portOffset, List<ServiceActivator> startServices, List<AbstractServerModelUpdate<?>> updates, ServerEnvironment environment) {
        this(null, portOffset, startServices, updates, environment);
    }

    private ServerStartTask(String serverName, int portOffset, List<ServiceActivator> startServices, List<AbstractServerModelUpdate<?>> updates, ServerEnvironment environment) {
        this.serverName = serverName;
        this.portOffset = portOffset;
        this.startServices = startServices;
        this.updates = updates;
        this.providedEnvironment = environment;
    }

    @Override
    public void run(List<ServiceActivator> startServices) {
        if (this.serverName != null) {
            MDC.put((String)"process", (Object)("server-" + this.serverName));
            log.infof("Starting server \"%s\"", (Object)this.serverName);
        } else {
            MDC.put((String)"process", (Object)"standalone-server");
            log.infof("Starting standalone server", new Object[0]);
        }
        final ServiceContainer container = ServiceContainer.Factory.create();
        int threads = Runtime.getRuntime().availableProcessors();
        container.setExecutor((Executor)new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>()));
        ServerStartupListener serverStartupListener = new ServerStartupListener(this.createListenerCallback());
        final ServerStartBatchBuilder batchBuilder = new ServerStartBatchBuilder(container.batchBuilder(), serverStartupListener);
        batchBuilder.addListener((ServiceListener<Object>)serverStartupListener);
        ServiceActivatorContext serviceActivatorContext = new ServiceActivatorContext(){

            public BatchBuilder getBatchBuilder() {
                return batchBuilder;
            }
        };
        BatchServiceBuilder builder = batchBuilder.addService(AS_SERVER_SERVICE_NAME, Service.NULL);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        for (ServiceActivator service : this.startServices) {
            service.activate(serviceActivatorContext);
        }
        for (ServiceActivator service : startServices) {
            service.activate(serviceActivatorContext);
        }
        ServerModel serverModel = new ServerModel(this.serverName, this.portOffset);
        Properties systemProperties = System.getProperties();
        ServerEnvironment environment = this.providedEnvironment != null ? this.providedEnvironment : new ServerEnvironment(systemProperties, this.serverName, false);
        log.info((Object)"Activating core services");
        ServerControllerImpl serverController = new ServerControllerImpl(serverModel, container, environment.isStandalone());
        batchBuilder.addService(ServerController.SERVICE_NAME, serverController).addDependency(ServerConfigurationPersister.SERVICE_NAME, ServerConfigurationPersister.class, serverController.getConfigurationPersisterValue()).addInjection(serverController.getExecutorValue(), (Object)Executors.newCachedThreadPool());
        ServerEnvironmentServices.addServices(environment, batchBuilder);
        ServerDeploymentRepositoryImpl.addService(batchBuilder);
        ShutdownHandlerImpl.addService(batchBuilder);
        ServerModelService.addService(serverModel, batchBuilder);
        ServerDeploymentManagerImpl.addService(serverModel, container, batchBuilder);
        ServerConfigurationPersisterImpl.addService(serverModel, batchBuilder);
        DeploymentScannerFactoryService.addService(batchBuilder);
        batchBuilder.addService(SocketBindingManager.SOCKET_BINDING_MANAGER, new SocketBindingManagerService(this.portOffset)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        batchBuilder.addService(ClassifyingModuleLoaderService.SERVICE_NAME, new ClassifyingModuleLoaderService());
        DeploymentModuleLoaderService deploymentModuleLoaderService = new DeploymentModuleLoaderService((DeploymentModuleLoader)new DeploymentModuleLoaderImpl());
        batchBuilder.addService(DeploymentModuleLoaderService.SERVICE_NAME, deploymentModuleLoaderService).addDependency(ClassifyingModuleLoaderService.SERVICE_NAME, ClassifyingModuleLoaderService.class, (Injector)new ClassifyingModuleLoaderInjector("deployment", (Value)deploymentModuleLoaderService));
        new JarDeploymentActivator().activate(new ServiceActivatorContext(){

            public BatchBuilder getBatchBuilder() {
                return batchBuilder;
            }
        });
        for (AbstractServerModelUpdate<?> update : this.updates) {
            try {
                serverModel.update(update);
            }
            catch (UpdateFailedException e) {
                throw new IllegalStateException("Failed to start server", e);
            }
        }
        UpdateContext context = new UpdateContext(){

            public BatchBuilder getBatchBuilder() {
                return batchBuilder;
            }

            public ServiceContainer getServiceContainer() {
                return container;
            }
        };
        for (AbstractServerModelUpdate<?> update : this.updates) {
            if (update.isDeploymentUpdate()) continue;
            update.applyUpdateBootAction(context);
        }
        StandaloneServerManagementServices.addServices(serverModel, container, batchBuilder);
        try {
            serverStartupListener.startBatch(this.createDeploymentTask(container, serverStartupListener));
            batchBuilder.install();
            serverStartupListener.finishBatch();
        }
        catch (ServiceRegistryException e) {
            throw new IllegalStateException("Failed to install boot services", e);
        }
    }

    private Runnable createDeploymentTask(final ServiceContainer container, final ServerStartupListener serverStartupListener) {
        return new Runnable(){

            @Override
            public void run() {
                final ServerStartBatchBuilder deploymentBatchBuilder = new ServerStartBatchBuilder(container.batchBuilder(), serverStartupListener);
                deploymentBatchBuilder.addListener((ServiceListener<Object>)serverStartupListener);
                serverStartupListener.startBatch(null);
                UpdateContext context = new UpdateContext(){

                    public BatchBuilder getBatchBuilder() {
                        return deploymentBatchBuilder;
                    }

                    public ServiceContainer getServiceContainer() {
                        return container;
                    }
                };
                for (AbstractServerModelUpdate update : ServerStartTask.this.updates) {
                    if (!update.isDeploymentUpdate()) continue;
                    update.applyUpdateBootAction(context);
                }
                serverStartupListener.finish();
                try {
                    deploymentBatchBuilder.install();
                    serverStartupListener.finishBatch();
                }
                catch (ServiceRegistryException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    ServerStartupListener.Callback createListenerCallback() {
        return new ServerStartupListener.Callback(){

            @Override
            public void run(Map<ServiceName, StartException> serviceFailures, long elapsedTime, int totalServices, int onDemandServices, int startedServices) {
                if (serviceFailures.isEmpty()) {
                    log.infof("JBoss AS %s \"%s\" started in %dms. - Services [Total: %d, On-demand: %d. Started: %d]", new Object[]{Version.AS_VERSION, Version.AS_RELEASE_CODENAME, elapsedTime, totalServices, onDemandServices, startedServices});
                } else {
                    StringBuilder buff = new StringBuilder(String.format("JBoss AS server start failed. Attempted to start %d services in %dms", totalServices, elapsedTime));
                    buff.append("\nThe following services failed to start:\n");
                    for (Map.Entry<ServiceName, StartException> entry : serviceFailures.entrySet()) {
                        buff.append(String.format("\t%s => %s\n", entry.getKey(), entry.getValue().getMessage()));
                    }
                    log.error((Object)buff.toString());
                }
            }
        };
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.serverName == null) {
            throw new InvalidObjectException("serverName is null");
        }
        if (this.portOffset < 0) {
            throw new InvalidObjectException("portOffset is out of range");
        }
        if (this.updates == null) {
            throw new InvalidObjectException("updates is null");
        }
        if (this.startServices == null) {
            throw new InvalidObjectException("startServices is null");
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ois.registerValidation(this, 100);
    }
}

