/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.server.mgmt.RollbackUpdateResultHandler;
import org.jboss.as.server.mgmt.SimpleUpdateContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceRegistryException;

public class ServerUpdateController {
    private static Logger logger = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private volatile Status status = Status.PENDING;
    private final boolean allowOverallRollback;
    private final boolean allowRuntimeUpdates;
    private final List<ServerModelUpdateTuple<?, ?>> updates = new ArrayList();
    private final List<ServerModelUpdateTuple<?, ?>> rollbacks = new ArrayList();
    private final ServerModel serverModel;
    private final ServiceContainer serviceContainer;
    private final Executor executor;
    private final ServerUpdateCommitHandler commitHandler;
    private final AtomicInteger updatedCount = new AtomicInteger();
    private final AtomicInteger rolledBackCount = new AtomicInteger();

    public ServerUpdateController(ServerModel serverModel, ServiceContainer serviceContainer, Executor executor, ServerUpdateCommitHandler commitHandler, boolean allowOverallRollback, boolean allowRuntimeUpdates) {
        this.serverModel = serverModel;
        this.serviceContainer = serviceContainer;
        this.executor = executor;
        this.commitHandler = commitHandler;
        this.allowOverallRollback = allowOverallRollback;
        this.allowRuntimeUpdates = allowRuntimeUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, P> void addServerModelUpdate(AbstractServerModelUpdate<R> update, UpdateResultHandler<? super R, P> resultHandler, P param) {
        ServerUpdateController serverUpdateController = this;
        synchronized (serverUpdateController) {
            if (this.status != Status.PENDING) {
                throw new IllegalStateException("Cannot add updates after executeUpdates() has been invoked");
            }
            this.updates.add(new ServerModelUpdateTuple<R, P>(update, resultHandler, param));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdates() {
        ServerUpdateController serverUpdateController = this;
        synchronized (serverUpdateController) {
            if (this.status != Status.PENDING) {
                throw new IllegalStateException("Status is " + (Object)((Object)this.status) + " -- must be " + (Object)((Object)Status.PENDING));
            }
            this.status = Status.ACTIVE;
            try {
                this.applyUpdates();
            }
            catch (Exception e) {
                this.handleRollback();
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    private void applyUpdates() {
        if (this.updates.size() == 0) {
            this.transition(false);
            return;
        }
        BatchBuilder batchBuilder = this.serviceContainer.batchBuilder();
        SimpleUpdateContext updateContext = new SimpleUpdateContext(this.serviceContainer, batchBuilder);
        for (ServerModelUpdateTuple<?, ?> update : this.updates) {
            logger.debugf("Applying update %s", (Object)update.getUpdate().toString());
            if (this.status != Status.ACTIVE) {
                ((ServerModelUpdateTuple)update).handleCancellation();
                continue;
            }
            boolean appliedToModel = false;
            ServerModelUpdateTuple rollbackTuple = null;
            try {
                rollbackTuple = ((ServerModelUpdateTuple)update).getRollbackTuple(this.serverModel);
                this.serverModel.update(update.getUpdate());
                appliedToModel = true;
                if (this.allowRuntimeUpdates) {
                    ((ServerModelUpdateTuple)update).applyUpdate(updateContext);
                } else {
                    this.updateComplete();
                }
                if (!this.allowOverallRollback || rollbackTuple == null) continue;
                this.rollbacks.add(0, rollbackTuple);
            }
            catch (Exception e) {
                ((ServerModelUpdateTuple)update).handleFailure(e);
                if (rollbackTuple == null || !appliedToModel) continue;
                try {
                    if (this.allowRuntimeUpdates) {
                        rollbackTuple.applyUpdate(updateContext);
                    }
                    this.serverModel.update(rollbackTuple.getUpdate());
                }
                catch (UpdateFailedException e1) {
                    rollbackTuple.handleFailure(e1);
                }
            }
        }
        if (this.status == Status.ACTIVE) {
            try {
                batchBuilder.install();
            }
            catch (ServiceRegistryException e) {
                this.handleRollback();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("%s update(s) applied", (Object)this.updates.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRollbacks() {
        if (this.rollbacks.size() == 0) {
            this.transition(false);
            return;
        }
        BatchBuilder batchBuilder = this.serviceContainer.batchBuilder();
        SimpleUpdateContext updateContext = new SimpleUpdateContext(this.serviceContainer, batchBuilder);
        boolean failed = false;
        try {
            for (ServerModelUpdateTuple<?, ?> update : this.rollbacks) {
                if (failed) {
                    ((ServerModelUpdateTuple)update).handleCancellation();
                    continue;
                }
                try {
                    this.serverModel.update(update.getUpdate());
                }
                catch (Exception e) {
                    ((ServerModelUpdateTuple)update).handleFailure(e);
                }
                finally {
                    try {
                        if (this.allowRuntimeUpdates) {
                            ((ServerModelUpdateTuple)update).applyUpdate(updateContext);
                            continue;
                        }
                        this.rollbackComplete();
                    }
                    catch (Exception e) {
                        ((ServerModelUpdateTuple)update).handleFailure(e);
                    }
                }
            }
            batchBuilder.install();
            if (logger.isDebugEnabled()) {
                logger.debugf("%s rollbacks applied", (Object)this.rollbacks.size());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Caught exception applying rollbacks", (Throwable)e);
        }
    }

    private void updateComplete() {
        this.updatedCount.incrementAndGet();
        this.transition(false);
    }

    private void updateFailed() {
        this.updatedCount.incrementAndGet();
        this.transition(true);
    }

    private void rollbackComplete() {
        this.rolledBackCount.incrementAndGet();
        this.transition(false);
    }

    private void rollbackFailed() {
        this.rolledBackCount.incrementAndGet();
        this.transition(false);
    }

    private void handleCommit() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug((Object)"Committing");
                ServerUpdateController serverUpdateController = ServerUpdateController.this;
                synchronized (serverUpdateController) {
                    Status priorStatus = ServerUpdateController.this.status;
                    ServerUpdateController.this.status = Status.COMMITING;
                    ServerUpdateController.this.commitHandler.handleUpdateCommit(ServerUpdateController.this, priorStatus);
                    Status newStatus = priorStatus == Status.ACTIVE || ServerUpdateController.this.allowOverallRollback ? Status.COMMITTED : Status.ROLLED_BACK;
                    ServerUpdateController.this.status = newStatus;
                }
                logger.debug((Object)"Committed");
            }
        };
        this.executor.execute(r);
    }

    private void handleRollback() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug((Object)"Rolling back");
                ServerUpdateController serverUpdateController = ServerUpdateController.this;
                synchronized (serverUpdateController) {
                    if (ServerUpdateController.this.status != Status.MARKED_ROLLBACK) {
                        return;
                    }
                    ServerUpdateController.this.status = Status.ROLLING_BACK;
                    ServerUpdateController.this.applyRollbacks();
                }
            }
        };
        this.executor.execute(r);
    }

    private void transition(boolean updateFailure) {
        if (logger.isTraceEnabled()) {
            logger.tracef("transition(): status=%s updates.size()=%s updatedCount=%s rollbacks.size()=%s rolledBackCount=%s", new Object[]{this.status, this.updates.size(), this.updatedCount.get(), this.rollbacks.size(), this.rolledBackCount.get()});
        }
        switch (this.status) {
            case ACTIVE: {
                if (updateFailure) {
                    this.status = Status.MARKED_ROLLBACK;
                }
                if (updateFailure && this.allowOverallRollback) {
                    this.handleRollback();
                    break;
                }
                if (this.updatedCount.get() != this.updates.size()) break;
                this.handleCommit();
                break;
            }
            case MARKED_ROLLBACK: {
                if (this.rolledBackCount.get() != this.rollbacks.size()) break;
                this.handleCommit();
                break;
            }
            case ROLLING_BACK: {
                if (this.rolledBackCount.get() != this.rollbacks.size()) break;
                this.handleCommit();
                break;
            }
            case ROLLED_BACK: 
            case COMMITING: 
            case COMMITTED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status " + (Object)((Object)this.status));
            }
        }
    }

    private class DelegatingUpdateResultHandler<R, P>
    implements UpdateResultHandler<R, P> {
        private final UpdateResultHandler<? super R, P> delegate;

        private DelegatingUpdateResultHandler(UpdateResultHandler<? super R, P> delegate) {
            this.delegate = delegate;
        }

        public void handleCancellation(P param) {
            ServerUpdateController.this.updateComplete();
            if (this.delegate != null) {
                this.delegate.handleCancellation(param);
            }
        }

        public void handleFailure(Throwable cause, P param) {
            ServerUpdateController.this.updateFailed();
            if (this.delegate != null) {
                this.delegate.handleFailure(cause, param);
            }
            logger.errorf(cause, "Caught exception handling update (param is %s)", param);
        }

        public void handleSuccess(R result, P param) {
            ServerUpdateController.this.updateComplete();
            if (this.delegate != null) {
                this.delegate.handleSuccess(result, param);
            }
        }

        public void handleTimeout(P param) {
            ServerUpdateController.this.updateFailed();
            if (this.delegate != null) {
                this.delegate.handleTimeout(param);
            }
        }

        public void handleRollbackFailure(Throwable cause, P param) {
            ServerUpdateController.this.rollbackFailed();
            if (this.delegate != null) {
                this.delegate.handleRollbackFailure(cause, param);
            }
            logger.errorf(cause, "Caught exception handling rollback of an update (param is %s)", param);
        }

        public void handleRollbackSuccess(P param) {
            ServerUpdateController.this.rollbackComplete();
            if (this.delegate != null) {
                this.delegate.handleRollbackSuccess(param);
            }
        }

        public void handleRollbackCancellation(P param) {
            ServerUpdateController.this.rollbackFailed();
            if (this.delegate != null) {
                this.delegate.handleRollbackCancellation(param);
            }
        }

        public void handleRollbackTimeout(P param) {
            ServerUpdateController.this.rollbackFailed();
            if (this.delegate != null) {
                this.delegate.handleRollbackTimeout(param);
            }
        }

        private UpdateResultHandler<? super R, P> getDelegate() {
            return this.delegate;
        }
    }

    private class ServerModelUpdateTuple<R, P> {
        private final AbstractServerModelUpdate<R> update;
        private final DelegatingUpdateResultHandler<? super R, P> resultHandler;
        private final P param;

        public ServerModelUpdateTuple(AbstractServerModelUpdate<R> update, UpdateResultHandler<? super R, P> resultHandler, P param) {
            if (update == null) {
                throw new IllegalArgumentException("update is null");
            }
            this.update = update;
            this.resultHandler = new DelegatingUpdateResultHandler(resultHandler);
            this.param = param;
        }

        public AbstractServerModelUpdate<R> getUpdate() {
            return this.update;
        }

        private void handleCancellation() {
            this.resultHandler.handleCancellation(this.param);
        }

        private void handleFailure(Throwable cause) {
            this.resultHandler.handleFailure(cause, this.param);
        }

        private void applyUpdate(UpdateContext container) {
            this.update.applyUpdate(container, this.resultHandler, this.param);
        }

        private ServerModelUpdateTuple<Object, P> getRollbackTuple(ServerModel serverModel) {
            ServerModelUpdateTuple<R, P> rollbackTuple = null;
            AbstractServerModelUpdate compensating = this.update.getCompensatingUpdate(serverModel);
            if (compensating != null) {
                RollbackUpdateResultHandler rollbackHandler = RollbackUpdateResultHandler.getRollbackUpdateResultHandler(((DelegatingUpdateResultHandler)this.resultHandler).getDelegate());
                rollbackTuple = new ServerModelUpdateTuple<R, P>(compensating, rollbackHandler, this.param);
            }
            return rollbackTuple;
        }
    }

    public static interface ServerUpdateCommitHandler {
        public void handleUpdateCommit(ServerUpdateController var1, Status var2);
    }

    public static enum Status {
        PENDING,
        ACTIVE,
        MARKED_ROLLBACK,
        ROLLING_BACK,
        COMMITING,
        ROLLED_BACK,
        COMMITTED;

    }
}

