/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SimpleFuture<V>
implements Future<V> {
    private V value;
    private volatile boolean done;
    private final Lock lock = new ReentrantLock();
    private final Condition hasValue = this.lock.newCondition();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.done) {
                this.hasValue.await();
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = unit.toMillis(timeout) + System.currentTimeMillis();
        this.lock.lock();
        try {
            while (!this.done) {
                long remaining = deadline - System.currentTimeMillis();
                if (remaining <= 0L) {
                    throw new TimeoutException();
                }
                this.hasValue.await(remaining, TimeUnit.MILLISECONDS);
            }
            V v = this.value;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(V value) {
        this.lock.lock();
        try {
            this.value = value;
            this.done = true;
            this.hasValue.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

