/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.as.deployment.ServerDeploymentRepository;
import org.jboss.as.deployment.module.TempFileProviderService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ServerDeploymentRepositoryImpl
implements ServerDeploymentRepository,
Service<ServerDeploymentRepository> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String CONTENT = "content";
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private File repoRoot;
    private MessageDigest messageDigest;
    private static char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void addService(BatchBuilder batchBuilder) {
        ServerDeploymentRepositoryImpl service = new ServerDeploymentRepositoryImpl();
        batchBuilder.addService(SERVICE_NAME, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.serverEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] addDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
        log.debugf("Adding content with name %s", (Object)name);
        byte[] sha1Bytes = null;
        File tmp = File.createTempFile(name, "tmp", this.repoRoot);
        FileOutputStream fos = new FileOutputStream(tmp);
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            try {
                int read;
                DigestOutputStream dos = new DigestOutputStream(fos, this.messageDigest);
                BufferedInputStream bis = new BufferedInputStream(stream);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    dos.write(bytes, 0, read);
                }
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception ignored) {}
            }
            sha1Bytes = this.messageDigest.digest();
        }
        String sha1 = ServerDeploymentRepositoryImpl.bytesToHexString(sha1Bytes);
        String partA = sha1.substring(0, 2);
        String partB = sha1.substring(2);
        File base = new File(this.repoRoot, partA);
        this.validateDir(base);
        File realDir = new File(base, partB);
        if (!realDir.exists() && !realDir.mkdirs()) {
            throw new IllegalStateException("Cannot create directory " + realDir.getAbsolutePath());
        }
        File realFile = new File(realDir, CONTENT);
        if (realFile.exists()) {
            if (!tmp.delete()) {
                tmp.deleteOnExit();
            }
            log.debugf("Content with name %s was already present in repository at location %s", (Object)name, (Object)realFile.getAbsolutePath());
        } else {
            this.moveTempToPermanent(tmp, realFile);
            log.infof("Content with name %s added at location %s", (Object)name, (Object)realFile.getAbsolutePath());
        }
        return sha1Bytes;
    }

    public Closeable mountDeploymentContent(String name, String runtimeName, byte[] deploymentHash, VirtualFile mountPoint) throws IOException {
        if (deploymentHash == null) {
            File file = new File(((ServerEnvironment)this.serverEnvironment.getValue()).getServerSystemDeployDir(), name);
            return VFS.mountZip((File)file, (VirtualFile)mountPoint, (TempFileProvider)TempFileProviderService.provider());
        }
        String sha1 = ServerDeploymentRepositoryImpl.bytesToHexString(deploymentHash);
        String partA = sha1.substring(0, 2);
        String partB = sha1.substring(2);
        File base = new File(this.repoRoot, partA);
        File hashDir = new File(base, partB);
        File content = new File(hashDir, CONTENT);
        if (name.endsWith("war")) {
            return VFS.mountZipExpanded((File)content, (VirtualFile)mountPoint, (TempFileProvider)TempFileProviderService.provider());
        }
        return VFS.mountZip((File)content, (VirtualFile)mountPoint, (TempFileProvider)TempFileProviderService.provider());
    }

    public void start(StartContext context) throws StartException {
        ServerEnvironment env = null;
        try {
            env = (ServerEnvironment)this.serverEnvironment.getValue();
        }
        catch (IllegalStateException ise) {
            throw new StartException(ServerEnvironment.class.getSimpleName() + " was not injected");
        }
        File deployDir = env.getServerDeployDir();
        if (deployDir == null) {
            throw new IllegalArgumentException("deployDir is null");
        }
        if (deployDir.exists()) {
            if (!deployDir.isDirectory()) {
                throw new IllegalStateException("Deployment repository root " + deployDir.getAbsolutePath() + " is not a directory");
            }
            if (!deployDir.canWrite()) {
                throw new IllegalStateException("Deployment repository root " + deployDir.getAbsolutePath() + " is not a writable");
            }
        } else if (!deployDir.mkdirs()) {
            throw new IllegalStateException("Failed to create a directory at " + deployDir.getAbsolutePath());
        }
        this.repoRoot = deployDir;
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new StartException("Cannot obtain SHA-1 " + MessageDigest.class.getSimpleName(), (Throwable)e);
        }
        log.debugf("%s started", (Object)ServerDeploymentRepository.class.getSimpleName());
    }

    public void stop(StopContext context) {
        this.repoRoot = null;
        log.debugf("%s stopped", (Object)ServerDeploymentRepository.class.getSimpleName());
    }

    public ServerDeploymentRepository getValue() throws IllegalStateException {
        return this;
    }

    private void validateDir(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IllegalStateException("Cannot create directory " + dir.getAbsolutePath());
            }
        } else {
            if (!dir.isDirectory()) {
                throw new IllegalStateException(dir.getAbsolutePath() + " is not a directory");
            }
            if (!dir.canWrite()) {
                throw new IllegalStateException("Cannot write to directory " + dir.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToPermanent(File tmpFile, File permanentFile) throws IOException {
        if (!tmpFile.renameTo(permanentFile)) {
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            FileInputStream fis = null;
            try {
                int read;
                fos = new FileOutputStream(permanentFile);
                bos = new BufferedOutputStream(fos);
                fis = new FileInputStream(tmpFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] bytes = new byte[8192];
                while ((read = bis.read(bytes)) > -1) {
                    ((BufferedOutputStream)bos).write(bytes, 0, read);
                }
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ignored) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignored) {}
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
            }
        }
    }

    protected static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(table[b >> 4 & 0xF]).append(table[b & 0xF]);
        }
        return builder.toString();
    }
}

