/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.standalone.management;

import java.util.concurrent.Executors;
import org.jboss.as.deployment.ServerDeploymentRepository;
import org.jboss.as.model.ManagementElement;
import org.jboss.as.model.ServerModel;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.server.ServerController;
import org.jboss.as.server.mgmt.ServerConfigurationPersister;
import org.jboss.as.server.mgmt.ShutdownHandler;
import org.jboss.as.server.standalone.management.ManagementCommunicationService;
import org.jboss.as.server.standalone.management.ManagementCommunicationServiceInjector;
import org.jboss.as.server.standalone.management.ServerControllerOperationHandler;
import org.jboss.as.services.net.NetworkInterfaceBinding;
import org.jboss.as.services.net.NetworkInterfaceService;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.Value;

public class StandaloneServerManagementServices {
    public static void addServices(ServerModel serverModel, ServiceContainer container, BatchBuilder batchBuilder) {
        ManagementElement managementElement = serverModel.getManagementElement();
        if (managementElement != null) {
            ManagementCommunicationService managementCommunicationService = new ManagementCommunicationService();
            batchBuilder.addService(ManagementCommunicationService.SERVICE_NAME, (Service)managementCommunicationService).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{managementElement.getInterfaceName()}), NetworkInterfaceBinding.class, managementCommunicationService.getInterfaceInjector()).addInjection(managementCommunicationService.getPortInjector(), (Object)managementElement.getPort()).addInjection(managementCommunicationService.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool()).addInjection(managementCommunicationService.getThreadFactoryInjector(), (Object)Executors.defaultThreadFactory()).setInitialMode(ServiceController.Mode.ACTIVE);
            ServerControllerOperationHandler clientOperationHandler = new ServerControllerOperationHandler(container);
            batchBuilder.addService(ServerControllerOperationHandler.SERVICE_NAME, (Service)clientOperationHandler).addDependency(ServerController.SERVICE_NAME, ServerController.class, clientOperationHandler.getServerControllerInjector()).addDependency(ManagementCommunicationService.SERVICE_NAME, ManagementCommunicationService.class, (Injector)new ManagementCommunicationServiceInjector((Value<? extends ManagementOperationHandler>)clientOperationHandler)).addDependency(ServerConfigurationPersister.SERVICE_NAME, ServerConfigurationPersister.class, clientOperationHandler.getConfigurationPersisterValue()).addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, clientOperationHandler.getDeploymentRepositoryInjector()).addDependency(ServerDeploymentManager.SERVICE_NAME_LOCAL, ServerDeploymentManager.class, clientOperationHandler.getDeploymentManagerInjector()).addDependency(ShutdownHandler.SERVICE_NAME, ShutdownHandler.class, clientOperationHandler.getShutdownHandlerValue()).addInjection(clientOperationHandler.getExecutorValue(), (Object)Executors.newCachedThreadPool()).setInitialMode(ServiceController.Mode.ACTIVE);
        }
    }
}

