/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.txn.CoordinatorEnvironmentElement;
import org.jboss.as.txn.CoreEnvironmentElement;
import org.jboss.as.txn.Element;
import org.jboss.as.txn.Namespace;
import org.jboss.as.txn.ObjectStoreEnvironmentElement;
import org.jboss.as.txn.RecoveryEnvironmentElement;
import org.jboss.as.txn.TransactionSubsystemAdd;
import org.jboss.as.txn.TxnServices;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class TransactionsSubsystemElement
extends AbstractSubsystemElement<TransactionsSubsystemElement> {
    private static final long serialVersionUID = 4097067542390229861L;
    private final RecoveryEnvironmentElement recoveryEnvironmentElement = new RecoveryEnvironmentElement();
    private final CoreEnvironmentElement coreEnvironmentElement = new CoreEnvironmentElement();
    private final CoordinatorEnvironmentElement coordinatorEnvironmentElement = new CoordinatorEnvironmentElement();
    private final ObjectStoreEnvironmentElement objectStoreEnvironmentElement = new ObjectStoreEnvironmentElement();

    public TransactionsSubsystemElement() {
        super(Namespace.TRANSACTIONS_1_0.getUriString());
    }

    protected Class<TransactionsSubsystemElement> getElementClass() {
        return TransactionsSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement(Element.RECOVERY_ENVIRONMENT.getLocalName());
        this.recoveryEnvironmentElement.writeContent(streamWriter);
        streamWriter.writeStartElement(Element.CORE_ENVIRONMENT.getLocalName());
        this.coreEnvironmentElement.writeContent(streamWriter);
        streamWriter.writeEmptyElement(Element.OBJECT_STORE.getLocalName());
        this.objectStoreEnvironmentElement.writeContent(streamWriter);
        streamWriter.writeEndElement();
    }

    public RecoveryEnvironmentElement getRecoveryEnvironmentElement() {
        return this.recoveryEnvironmentElement;
    }

    public CoreEnvironmentElement getCoreEnvironmentElement() {
        return this.coreEnvironmentElement;
    }

    public CoordinatorEnvironmentElement getCoordinatorEnvironmentElement() {
        return this.coordinatorEnvironmentElement;
    }

    public void setCoordinatorEnableStatistics(boolean enable) {
        this.coordinatorEnvironmentElement.setEnableStatistics(enable);
    }

    public void setCoordinatorDefaultTimeout(int timeout) {
        this.coordinatorEnvironmentElement.setDefaultTimeout(timeout);
    }

    public ObjectStoreEnvironmentElement getObjectStoreEnvironmentElement() {
        return this.objectStoreEnvironmentElement;
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<TransactionsSubsystemElement, ?>> list) {
    }

    protected boolean isEmpty() {
        return true;
    }

    protected TransactionSubsystemAdd getAdd() {
        TransactionSubsystemAdd add = new TransactionSubsystemAdd();
        add.setBindingName(this.coreEnvironmentElement.getBindingRef());
        add.setMaxPorts(this.coreEnvironmentElement.getMaxPorts());
        add.setNodeIdentifier(this.coreEnvironmentElement.getNodeIdentifier());
        add.setRecoveryBindingName(this.recoveryEnvironmentElement.getBindingRef());
        add.setRecoveryStatusBindingName(this.recoveryEnvironmentElement.getStatusBindingRef());
        add.setCoordinatorEnableStatistics(this.coordinatorEnvironmentElement.isEnableStatistics());
        add.setCoordinatorDefaultTimeout(this.coordinatorEnvironmentElement.getDefaultTimeout());
        add.setObjectStorePathRef(this.objectStoreEnvironmentElement.getRelativeTo());
        add.setObjectStoreDirectory(this.objectStoreEnvironmentElement.getPath());
        return add;
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceContainer container = updateContext.getServiceContainer();
        ServiceController tmController = container.getService(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER);
        tmController.setMode(ServiceController.Mode.REMOVE);
        ServiceController xaController = container.getService(TxnServices.JBOSS_TXN_XA_TERMINATOR);
        xaController.setMode(ServiceController.Mode.REMOVE);
    }
}

