/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.deployment.managedbean.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.ManagedBean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.managedbean.config.InterceptorConfiguration;
import org.jboss.as.deployment.managedbean.config.ManagedBeanConfiguration;
import org.jboss.as.deployment.managedbean.config.ManagedBeanConfigurations;
import org.jboss.as.deployment.managedbean.config.ResourceConfiguration;
import org.jboss.as.deployment.module.ModuleDeploymentProcessor;
import org.jboss.as.deployment.processor.AnnotationIndexProcessor;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class ManagedBeanAnnotationProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.POST_MODULE_DESCRIPTORS.plus(100L);
    private static final DotName MANAGED_BEAN_ANNOTATION_NAME = DotName.createSimple((String)ManagedBean.class.getName());
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName INTERCEPTORS_ANNOTATION_NAME = DotName.createSimple((String)Interceptors.class.getName());

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        if (context.getAttachment(ManagedBeanConfigurations.ATTACHMENT_KEY) != null) {
            return;
        }
        Index index = (Index)context.getAttachment(AnnotationIndexProcessor.ATTACHMENT_KEY);
        if (index == null) {
            return;
        }
        List targets = index.getAnnotationTargets(MANAGED_BEAN_ANNOTATION_NAME);
        if (targets == null) {
            return;
        }
        Module module = (Module)context.getAttachment(ModuleDeploymentProcessor.MODULE_ATTACHMENT_KEY);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Manged bean annotation processing requires a module.");
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        ManagedBeanConfigurations managedBeanConfigurations = new ManagedBeanConfigurations();
        context.putAttachment(ManagedBeanConfigurations.ATTACHMENT_KEY, (Object)managedBeanConfigurations);
        for (AnnotationTarget target : targets) {
            Class<?> beanClass;
            if (!(target instanceof ClassInfo)) {
                throw new DeploymentUnitProcessingException("The ManagedBean annotation is only allowed at the class level: " + target);
            }
            ClassInfo classInfo = (ClassInfo)ClassInfo.class.cast(target);
            String beanClassName = classInfo.name().toString();
            try {
                beanClass = classLoader.loadClass(beanClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Failed to load managed bean class: " + beanClassName);
            }
            ManagedBean managedBeanAnnotation = beanClass.getAnnotation(ManagedBean.class);
            String beanName = managedBeanAnnotation.value().isEmpty() ? beanClassName : managedBeanAnnotation.value();
            ManagedBeanConfiguration managedBeanConfiguration = new ManagedBeanConfiguration(beanName, beanClass);
            this.processLifecycleMethods(managedBeanConfiguration, beanClass, index);
            Map classAnnotations = classInfo.annotations();
            managedBeanConfiguration.setResourceConfigurations(this.processResources(classAnnotations, beanClass));
            managedBeanConfiguration.setInterceptorConfigurations(this.processInterceptors(index, classAnnotations, beanClass));
            managedBeanConfigurations.add(managedBeanConfiguration);
        }
    }

    private void processLifecycleMethods(ManagedBeanConfiguration managedBeanConfiguration, Class<?> beanClass, Index index) throws DeploymentUnitProcessingException {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        ArrayList<Method> preDestroyMethods = new ArrayList<Method>();
        for (Class<?> current = beanClass; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
            Method preDestroyMethod;
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)current.getName()));
            Method postConstructMethod = this.getSingleAnnotatedMethod(current, classInfo, PostConstruct.class, false);
            if (postConstructMethod != null) {
                postConstructMethods.add(postConstructMethod);
            }
            if ((preDestroyMethod = this.getSingleAnnotatedMethod(current, classInfo, PreDestroy.class, false)) == null) continue;
            preDestroyMethods.add(preDestroyMethod);
        }
        managedBeanConfiguration.setPostConstructMethods(postConstructMethods);
        managedBeanConfiguration.setPreDestroyMethods(preDestroyMethods);
    }

    private List<InterceptorConfiguration> processInterceptors(Index index, Map<DotName, List<AnnotationTarget>> beanClassAnnotations, Class<?> beanClass) throws DeploymentUnitProcessingException {
        Method aroundInvokeMethod;
        Class[] interceptorTypes;
        List<AnnotationTarget> interceptorTargets = beanClassAnnotations.get(INTERCEPTORS_ANNOTATION_NAME);
        if (interceptorTargets == null || interceptorTargets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorConfiguration> interceptorConfigurations = new ArrayList<InterceptorConfiguration>(interceptorTargets.size());
        Interceptors interceptorsAnnotation = beanClass.getAnnotation(Interceptors.class);
        for (Class interceptorType : interceptorTypes = interceptorsAnnotation.value()) {
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)interceptorType.getName()));
            if (classInfo == null) continue;
            Map interceptorClassAnnotations = classInfo.annotations();
            Method aroundInvokeMethod2 = this.getSingleAnnotatedMethod(interceptorType, classInfo, AroundInvoke.class, true);
            List<ResourceConfiguration> resourceConfigurations = this.processResources(interceptorClassAnnotations, interceptorType);
            interceptorConfigurations.add(new InterceptorConfiguration(interceptorType, aroundInvokeMethod2, resourceConfigurations));
        }
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)beanClass.getName()));
        if (classInfo != null && (aroundInvokeMethod = this.getSingleAnnotatedMethod(beanClass, classInfo, AroundInvoke.class, true)) != null) {
            List<ResourceConfiguration> resources = this.processClassResources(beanClass);
            interceptorConfigurations.add(new InterceptorConfiguration(beanClass, aroundInvokeMethod, resources));
        }
        return interceptorConfigurations;
    }

    private Method getSingleAnnotatedMethod(Class<?> type, ClassInfo classInfo, Class<? extends Annotation> annotationType, boolean requireInvocationContext) throws DeploymentUnitProcessingException {
        Method method = null;
        if (classInfo != null) {
            Map classAnnotations = classInfo.annotations();
            List targets = (List)classAnnotations.get(DotName.createSimple((String)annotationType.getName()));
            if (targets == null || targets.isEmpty()) {
                return null;
            }
            if (targets.size() > 1) {
                throw new DeploymentUnitProcessingException("Only one method may be annotated with " + annotationType + " per managed bean.");
            }
            AnnotationTarget target = (AnnotationTarget)targets.get(0);
            if (!(target instanceof MethodInfo)) {
                throw new DeploymentUnitProcessingException(annotationType + " is only valid on method targets.");
            }
            MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
            Type[] args = methodInfo.args();
            try {
                switch (args.length) {
                    case 0: {
                        if (requireInvocationContext) {
                            throw new DeploymentUnitProcessingException("Missing argument.  Methods annotated with " + annotationType + " must have either single InvocationContext argument.");
                        }
                        method = type.getDeclaredMethod(methodInfo.name(), new Class[0]);
                        break;
                    }
                    case 1: {
                        if (!InvocationContext.class.getName().equals(args[0].name().toString())) {
                            throw new DeploymentUnitProcessingException("Invalid argument type.  Methods annotated with " + annotationType + " must have either single InvocationContext argument.");
                        }
                        method = type.getDeclaredMethod(methodInfo.name(), InvocationContext.class);
                        break;
                    }
                    default: {
                        throw new DeploymentUnitProcessingException("Invalid number of arguments for method " + methodInfo.name() + " annotated with " + annotationType + " on class " + type.getName());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                throw new DeploymentUnitProcessingException("Failed to get " + annotationType + " method for type: " + type.getName(), (Throwable)e);
            }
        } else {
            block10: for (Method typeMethod : type.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationType)) continue;
                method = typeMethod;
                switch (method.getParameterTypes().length) {
                    case 0: {
                        if (!requireInvocationContext) break block10;
                        throw new DeploymentUnitProcessingException("Method " + method.getName() + " annotated with " + annotationType + " must have a single InvocationContext parameter");
                    }
                    case 1: {
                        if (!InvocationContext.class.equals(method.getParameterTypes()[0])) {
                            throw new DeploymentUnitProcessingException("Method " + method.getName() + " annotated with " + annotationType + " must have a single InvocationContext parameter.");
                        }
                    }
                    default: {
                        throw new DeploymentUnitProcessingException("Methods " + method.getName() + " annotated with " + annotationType + " can only have a single InvocationContext parameter.");
                    }
                }
            }
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    private List<ResourceConfiguration> processResources(Map<DotName, List<AnnotationTarget>> classAnnotations, Class<?> owningClass) throws DeploymentUnitProcessingException {
        List<AnnotationTarget> resourceTargets = classAnnotations.get(RESOURCE_ANNOTATION_NAME);
        if (resourceTargets == null) {
            return Collections.emptyList();
        }
        ArrayList<ResourceConfiguration> resourceConfigurations = new ArrayList<ResourceConfiguration>(resourceTargets.size());
        for (AnnotationTarget annotationTarget : resourceTargets) {
            ResourceConfiguration resourceConfiguration;
            if (annotationTarget instanceof FieldInfo) {
                resourceConfiguration = this.processFieldResource((FieldInfo)FieldInfo.class.cast(annotationTarget), owningClass);
            } else if (annotationTarget instanceof MethodInfo) {
                resourceConfiguration = this.processMethodResource((MethodInfo)MethodInfo.class.cast(annotationTarget), owningClass);
            } else {
                if (!(annotationTarget instanceof ClassInfo)) continue;
                Resource resource = owningClass.getAnnotation(Resource.class);
                if (resource == null) {
                    throw new DeploymentUnitProcessingException("Failed to get @Resource annotation from class " + owningClass.getName());
                }
                resourceConfiguration = this.processClassResource(owningClass, resource);
            }
            if (resourceConfiguration == null) continue;
            resourceConfigurations.add(resourceConfiguration);
        }
        resourceConfigurations.addAll(this.processClassResources(owningClass));
        return resourceConfigurations;
    }

    private ResourceConfiguration processFieldResource(FieldInfo fieldInfo, Class<?> owningClass) throws DeploymentUnitProcessingException {
        Field field;
        String fieldName = fieldInfo.name();
        try {
            field = owningClass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new DeploymentUnitProcessingException("Failed to get field '" + fieldName + "' from class '" + owningClass + "'", (Throwable)e);
        }
        Resource resource = field.getAnnotation(Resource.class);
        if (resource != null) {
            String localContextName = resource.name().isEmpty() ? fieldName : resource.name();
            Class injectionType = resource.type().equals(Object.class) ? field.getType() : resource.type();
            return new ResourceConfiguration(fieldName, field, ResourceConfiguration.TargetType.FIELD, injectionType, localContextName, this.getTargetContextName(resource, fieldName, injectionType));
        }
        return null;
    }

    private ResourceConfiguration processMethodResource(MethodInfo methodInfo, Class<?> owningClass) throws DeploymentUnitProcessingException {
        Method method;
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new DeploymentUnitProcessingException("@Resource injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        try {
            method = owningClass.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentUnitProcessingException("Failed to get method '" + methodName + "' from class '" + owningClass + "'", (Throwable)e);
        }
        Resource resource = method.getAnnotation(Resource.class);
        if (resource != null) {
            String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            Class injectionType = resource.type().equals(Object.class) ? method.getReturnType() : resource.type();
            String localContextName = resource.name().isEmpty() ? contextNameSuffix : resource.name();
            return new ResourceConfiguration(methodName, method, ResourceConfiguration.TargetType.METHOD, injectionType, localContextName, this.getTargetContextName(resource, contextNameSuffix, injectionType));
        }
        return null;
    }

    private ResourceConfiguration processClassResource(Class<?> owningClass, Resource resource) throws DeploymentUnitProcessingException {
        if (resource.name().isEmpty()) {
            throw new DeploymentUnitProcessingException("Class level @Resource annotations must provide a name.");
        }
        if (resource.mappedName().isEmpty()) {
            throw new DeploymentUnitProcessingException("Class level @Resource annotations must provide a mapped name.");
        }
        if (Object.class.equals((Object)resource.type())) {
            throw new DeploymentUnitProcessingException("Class level @Resource annotations must provide a type.");
        }
        return new ResourceConfiguration(owningClass.getName(), null, ResourceConfiguration.TargetType.CLASS, resource.type(), resource.name(), resource.mappedName());
    }

    private List<ResourceConfiguration> processClassResources(Class<?> owningClass) throws DeploymentUnitProcessingException {
        Resources resources = owningClass.getAnnotation(Resources.class);
        if (resources == null) {
            return Collections.emptyList();
        }
        Resource[] resourceAnnotations = resources.value();
        ArrayList<ResourceConfiguration> resourceConfigurations = new ArrayList<ResourceConfiguration>(resourceAnnotations.length);
        for (Resource resource : resourceAnnotations) {
            resourceConfigurations.add(this.processClassResource(owningClass, resource));
        }
        return resourceConfigurations;
    }

    private String getTargetContextName(Resource resource, String contextNameSuffix, Class<?> injectionType) throws DeploymentUnitProcessingException {
        String targetContextName = resource.mappedName();
        if (targetContextName.isEmpty()) {
            if (this.isEnvironmentEntryType(injectionType)) {
                targetContextName = contextNameSuffix;
            } else if (injectionType.isAnnotationPresent(ManagedBean.class)) {
                ManagedBean managedBean = injectionType.getAnnotation(ManagedBean.class);
                targetContextName = managedBean.value().isEmpty() ? injectionType.getName() : managedBean.value();
            } else {
                throw new DeploymentUnitProcessingException("Unable to determine mapped name for @Resource injection.");
            }
        }
        return targetContextName;
    }

    private boolean isEnvironmentEntryType(Class<?> type) {
        return type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive();
    }
}

